/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.in;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.sf.jqql.Util;
import net.sf.jqql.beans.ClusterIM;
import net.sf.jqql.beans.CustomHead;
import net.sf.jqql.beans.FileInfo;
import net.sf.jqql.beans.FileTransferArgs;
import net.sf.jqql.beans.NormalIM;
import net.sf.jqql.beans.NormalIMHeader;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.beans.ReceiveIMHeader;
import net.sf.jqql.beans.SMS;
import net.sf.jqql.beans.TempSessionIM;
import net.sf.jqql.beans.UserPropertyChange;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicInPacket;

public class ReceiveIMPacket
extends _08BasicInPacket {
    public byte[] reply;
    public boolean empty;
    public ReceiveIMHeader header;
    public NormalIMHeader normalHeader;
    public NormalIM normalIM;
    public byte systemMessageType;
    public String sysMessage;
    public FileInfo fileInfo;
    public FileTransferArgs fileArgs;
    public byte transferType;
    public ClusterIM clusterIM;
    public int externalId;
    public byte clusterType;
    public int sender;
    public String message;
    public byte role;
    public byte opCode;
    public int memberQQ;
    public int signatureOwner;
    public int modifiedTime;
    public String signature;
    public SMS sms;
    public TempSessionIM tempSessionIM;
    public List<CustomHead> headChanges;
    public UserPropertyChange propertyChange;
    public int friendQQ = 0;
    public int userQQ = 0;
    public int flag = 0;

    public ReceiveIMPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        return "Receive IM _08Packet";
    }

    protected void parseBody(ByteBuffer byteBuffer) throws PacketParseException {
        this.empty = false;
        if (byteBuffer.remaining() < 16) {
            throw new PacketParseException("\u6536\u5230\u7684\u6d88\u606f\u592a\u77ed\uff0c\u629b\u5f03\u8be5\u6d88\u606f");
        }
        this.reply = new byte[16];
        byteBuffer.get(this.reply);
        byteBuffer.rewind();
        this.header = new ReceiveIMHeader();
        this.header.readBean(byteBuffer);
        if (!byteBuffer.hasRemaining()) {
            this.empty = true;
            return;
        }
        int n = 0;
        switch (this.header.type) {
            case '\t': 
            case 'y': {
                this.parseNormalIM(byteBuffer);
                break;
            }
            case '\u0084': 
            case '\u0085': {
                this.parseNormalIMEx(byteBuffer);
                break;
            }
            case '\u001f': {
                this.tempSessionIM = new TempSessionIM();
                this.tempSessionIM.readBean(byteBuffer);
                break;
            }
            case '0': {
                this.parseSystemMessage(byteBuffer);
                break;
            }
            case '+': {
                this.parseClusterIM(byteBuffer);
                break;
            }
            case '*': {
                this.parseTempClusterIM(byteBuffer);
                break;
            }
            case ' ': {
                this.parseUnknownClusterIM(byteBuffer);
                break;
            }
            case '\u000b': {
                this.sms = new SMS();
                this.sms.readBindUserSMS(byteBuffer);
                break;
            }
            case '\u0013': {
                this.sms = new SMS();
                this.sms.readMobileQQSMS(byteBuffer);
                break;
            }
            case '\u0014': {
                this.sms = new SMS();
                this.sms.readMobileQQ2SMS(byteBuffer);
                break;
            }
            case '\f': {
                this.sms = new SMS();
                this.sms.readMobileSMS(byteBuffer);
                break;
            }
            case '!': 
            case '\"': 
            case '&': {
                this.externalId = byteBuffer.getInt();
                this.clusterType = byteBuffer.get();
                this.sender = byteBuffer.getInt();
                break;
            }
            case '#': 
            case '$': 
            case '%': {
                this.externalId = byteBuffer.getInt();
                this.clusterType = byteBuffer.get();
                this.sender = byteBuffer.getInt();
                n = byteBuffer.get() & 0xFF;
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray);
                this.message = Util.getString(byArray);
                break;
            }
            case ',': {
                this.externalId = byteBuffer.getInt();
                this.clusterType = byteBuffer.get();
                this.opCode = byteBuffer.get();
                this.memberQQ = byteBuffer.getInt();
                this.role = byteBuffer.get();
                this.sender = this.externalId;
                break;
            }
            case 'A': {
                this.signatureOwner = byteBuffer.getInt();
                this.modifiedTime = byteBuffer.getInt();
                n = byteBuffer.get() & 0xFF;
                this.signature = Util.getString(byteBuffer, n);
                break;
            }
            case '\u0004': {
                byteBuffer.get();
                break;
            }
            case 'I': {
                int n2 = byteBuffer.get() & 0xFF;
                if (n2 <= 0) break;
                this.headChanges = new ArrayList<CustomHead>();
                while (byteBuffer.hasRemaining()) {
                    CustomHead customHead = new CustomHead();
                    customHead.readBean(byteBuffer);
                    this.headChanges.add(customHead);
                }
                break;
            }
            case '\u001e': {
                this.propertyChange = new UserPropertyChange();
                this.propertyChange.readBean(byteBuffer);
                break;
            }
        }
    }

    private void parseUnknownClusterIM(ByteBuffer byteBuffer) {
        this.clusterIM = new ClusterIM(' ');
        this.clusterIM.readBean(byteBuffer);
    }

    private void parseTempClusterIM(ByteBuffer byteBuffer) {
        this.clusterIM = new ClusterIM('*');
        this.clusterIM.readBean(byteBuffer);
    }

    private void parseClusterIM(ByteBuffer byteBuffer) {
        this.clusterIM = new ClusterIM('+');
        this.clusterIM.readBean(byteBuffer);
    }

    private void parseSystemMessage(ByteBuffer byteBuffer) {
        this.systemMessageType = byteBuffer.get();
        int n = byteBuffer.get() & 0xFF;
        this.sysMessage = Util.getString(byteBuffer, n);
    }

    private void parseNormalIM(ByteBuffer byteBuffer) throws PacketParseException {
        try {
            this.normalHeader = new NormalIMHeader();
            this.normalHeader.readBean(byteBuffer);
            if (this.normalHeader.type == '\u000b') {
                this.normalIM = new NormalIM();
                this.normalIM.readBean(byteBuffer);
            } else if (this.normalHeader.type == '5' || this.normalHeader.type == '\u0001') {
                this.fileArgs = new FileTransferArgs();
                this.fileArgs.readBean(byteBuffer);
                this.fileInfo = new FileInfo();
                this.fileInfo.readBean(byteBuffer);
            } else if (this.normalHeader.type == '7' || this.normalHeader.type == ';') {
                this.fileArgs = new FileTransferArgs();
                this.fileArgs.readBean(byteBuffer);
            }
            log.debug((Object)("\u6536\u5230\u7684\u666e\u901a\u6d88\u606f\u7c7b\u578b\u4e3a:" + Util.getNormalIMTypeString(this.normalHeader.type)));
        }
        catch (Exception exception) {
            throw new PacketParseException(exception.getMessage());
        }
    }

    private void parseNormalIMEx(ByteBuffer byteBuffer) {
        this.normalHeader = new NormalIMHeader();
        this.normalHeader.readBean(byteBuffer);
        switch (this.normalHeader.type) {
            case '\u000b': {
                this.normalIM = new NormalIM();
                this.normalIM.readBeanEx(byteBuffer);
            }
        }
    }

    public int getMessageCategory() {
        switch (this.header.type) {
            case '0': {
                return 1;
            }
            case '\t': 
            case 'y': 
            case '\u0084': {
                return 0;
            }
            case '\u001f': {
                return 4;
            }
            case ' ': 
            case '*': 
            case '+': {
                return 2;
            }
            case '\u000b': 
            case '\f': 
            case '\u0013': 
            case '\u0014': {
                return 3;
            }
        }
        return 1;
    }
}

