/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.log;

import java.lang.reflect.Method;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;

class Slf4jLog
implements Logger {
    private static final String LOGGER = "org.slf4j.Logger";
    private static final String LOGGERFACTORY = "org.slf4j.LoggerFactory";
    private static final Object[] NO_ARGS = new Object[0];
    private Method infoSOO;
    private Method debugSOO;
    private Method debugST;
    private Method debugEnabled;
    private Method warnSOO;
    private Method warnST;
    private Method errorST;
    private Object logger;

    Slf4jLog() throws Exception {
        this("org.mortbay.log");
    }

    Slf4jLog(String name) throws Exception {
        Class<?> slf4j = null;
        Class<?> slf4jf = null;
        try {
            slf4j = this.getClass().getClassLoader().loadClass(LOGGER);
            slf4jf = this.getClass().getClassLoader().loadClass(LOGGERFACTORY);
        }
        catch (Exception e) {
            slf4j = Thread.currentThread().getContextClassLoader() == null ? Class.forName(LOGGER) : Thread.currentThread().getContextClassLoader().loadClass(LOGGER);
            slf4jf = Thread.currentThread().getContextClassLoader() == null ? Class.forName(LOGGERFACTORY) : Thread.currentThread().getContextClassLoader().loadClass(LOGGERFACTORY);
        }
        this.infoSOO = slf4j.getMethod("info", String.class, Object.class, Object.class);
        this.debugSOO = slf4j.getMethod("debug", String.class, Object.class, Object.class);
        this.debugST = slf4j.getMethod("debug", String.class, Throwable.class);
        this.debugEnabled = slf4j.getMethod("isDebugEnabled", new Class[0]);
        this.warnSOO = slf4j.getMethod("warn", String.class, Object.class, Object.class);
        this.warnST = slf4j.getMethod("warn", String.class, Throwable.class);
        this.errorST = slf4j.getMethod("error", String.class, Throwable.class);
        Method getLogger = slf4jf.getMethod("getLogger", String.class);
        this.logger = getLogger.invoke(null, name);
    }

    public void debug(String msg, Object arg0, Object arg1) {
        try {
            this.debugSOO.invoke(this.logger, msg, arg0, arg1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void debug(String msg, Throwable th) {
        try {
            this.debugST.invoke(this.logger, msg, th);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isDebugEnabled() {
        try {
            return (Boolean)this.debugEnabled.invoke(this.logger, NO_ARGS);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public void info(String msg, Object arg0, Object arg1) {
        try {
            this.infoSOO.invoke(this.logger, msg, arg0, arg1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void warn(String msg, Object arg0, Object arg1) {
        try {
            this.warnSOO.invoke(this.logger, msg, arg0, arg1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void warn(String msg, Throwable th) {
        try {
            if (th instanceof RuntimeException || th instanceof Error) {
                this.errorST.invoke(this.logger, msg, th);
            } else {
                this.warnST.invoke(this.logger, msg, th);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Logger getLogger(String name) {
        try {
            return new Slf4jLog(name);
        }
        catch (Exception e) {
            Log.warn(e);
            return this;
        }
    }

    public String toString() {
        return this.logger.toString();
    }

    public void setDebugEnabled(boolean enabled) {
        this.warn("setDebugEnabled not implemented", null, null);
    }
}

