/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.mortbay.io.Buffer;
import org.mortbay.io.Connection;
import org.mortbay.io.nio.ChannelEndPoint;
import org.mortbay.io.nio.SelectorManager;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpException;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements Runnable {
    protected SelectorManager _manager;
    protected SelectorManager.SelectSet _selectSet;
    protected boolean _dispatched = false;
    protected boolean _writable = true;
    protected SelectionKey _key;
    protected int _interestOps;
    protected boolean _readBlocked;
    protected boolean _writeBlocked;
    protected Connection _connection;
    private Timeout.Task _timeoutTask = new IdleTask();

    public Connection getConnection() {
        return this._connection;
    }

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) {
        super(channel);
        this._manager = selectSet.getManager();
        this._selectSet = selectSet;
        this._connection = this._manager.newConnection(channel, this);
        this._manager.endPointOpened(this);
        this._key = key;
        this._key.attach(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(boolean assumeShortDispatch) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._key == null) {
                this._readBlocked = false;
                this._writeBlocked = false;
                this.notifyAll();
                return false;
            }
            if (this._readBlocked || this._writeBlocked) {
                if (this._readBlocked && this._key.isReadable()) {
                    this._readBlocked = false;
                }
                if (this._writeBlocked && this._key.isWritable()) {
                    this._writeBlocked = false;
                }
                this.notifyAll();
                this._key.interestOps(0);
                return false;
            }
            if (!assumeShortDispatch) {
                this._key.interestOps(0);
            }
            if (this._dispatched) {
                this._key.interestOps(0);
                return false;
            }
            if ((this._key.readyOps() & 4) == 4 && (this._key.interestOps() & 4) == 4) {
                this._interestOps = this._key.interestOps() & 0xFFFFFFFB;
                this._key.interestOps(this._interestOps);
            }
            this._dispatched = true;
        }
        return true;
    }

    public void scheduleIdle() {
        this._selectSet.scheduleIdle(this._timeoutTask);
    }

    public void cancelIdle() {
        this._selectSet.cancelIdle(this._timeoutTask);
    }

    protected void idleExpired() {
        try {
            this.close();
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            try {
                this._dispatched = false;
                if (this.getChannel().isOpen()) {
                    this.updateKey();
                }
            }
            catch (Exception e) {
                Log.ignore((Throwable)e);
                this._interestOps = -1;
                this._selectSet.addChange(this);
            }
        }
    }

    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int l = super.flush(header, buffer, trailer);
        this._writable = l > 0;
        return l;
    }

    public int flush(Buffer buffer) throws IOException {
        int l = super.flush(buffer);
        this._writable = l > 0;
        return l;
    }

    public boolean isOpen() {
        SelectionKey key = this._key;
        return super.isOpen() && key != null && key.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean blockReadable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            long start = this._selectSet.getNow();
            try {
                boolean bl;
                block9: {
                    this._readBlocked = true;
                    while (this.isOpen()) {
                        if (!this._readBlocked) return true;
                        try {
                            this.updateKey();
                            this.wait(timeoutMs);
                            if (!this._readBlocked || timeoutMs >= this._selectSet.getNow() - start) continue;
                            bl = false;
                            break block9;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return true;
                }
                return bl;
            }
            finally {
                this._readBlocked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean blockWritable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            long start = this._selectSet.getNow();
            try {
                boolean bl;
                block9: {
                    this._writeBlocked = true;
                    while (this.isOpen()) {
                        if (!this._writeBlocked) return true;
                        try {
                            this.updateKey();
                            this.wait(timeoutMs);
                            if (!this._writeBlocked || timeoutMs >= this._selectSet.getNow() - start) continue;
                            bl = false;
                            break block9;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return true;
                }
                return bl;
            }
            finally {
                this._writeBlocked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            int ops = this._key == null ? 0 : this._key.interestOps();
            this._interestOps = ops | (!this._dispatched || this._readBlocked ? 1 : 0) | (!this._writable || this._writeBlocked ? 4 : 0);
            this._writable = true;
            if (this._interestOps != ops) {
                this._selectSet.addChange(this);
                this._selectSet.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._key != null && this._key.isValid()) {
                if (this._interestOps >= 0) {
                    this._key.interestOps(this._interestOps);
                } else {
                    this._key.cancel();
                    this._manager.endPointClosed(this);
                    this._key = null;
                }
            } else {
                this._key = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this._connection.handle();
        }
        catch (ClosedChannelException e) {
            Log.ignore((Throwable)e);
        }
        catch (EofException e) {
            Log.debug((String)"EOF", (Object)e);
            try {
                this.close();
            }
            catch (IOException e2) {
                Log.ignore((Throwable)e2);
            }
        }
        catch (HttpException e) {
            Log.debug((String)"BAD", (Object)e);
            try {
                this.close();
            }
            catch (IOException e2) {
                Log.ignore((Throwable)e2);
            }
        }
        catch (Throwable e) {
            Log.warn((String)"handle failed", (Throwable)e);
            try {
                this.close();
            }
            catch (IOException e2) {
                Log.ignore((Throwable)e2);
            }
        }
        finally {
            this.undispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._key != null) {
                this._key.cancel();
            }
            this._key = null;
        }
        try {
            super.close();
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
    }

    public String toString() {
        return "HEP@" + this.hashCode() + "[d=" + this._dispatched + ",io=" + this._interestOps + ",w=" + this._writable + ",b=" + this._readBlocked + "|" + this._writeBlocked + "]";
    }

    public Timeout.Task getTimeoutTask() {
        return this._timeoutTask;
    }

    public SelectorManager.SelectSet getSelectSet() {
        return this._selectSet;
    }

    public class IdleTask
    extends Timeout.Task {
        public void expire() {
            SelectChannelEndPoint.this.idleExpired();
        }

        public String toString() {
            return "TimeoutTask:" + SelectChannelEndPoint.this.toString();
        }
    }
}

