/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.multimap.impl.client.MultiMapKeyBasedRequest;
import com.hazelcast.multimap.impl.operations.RemoveOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class RemoveRequest
extends MultiMapKeyBasedRequest {
    Data value;
    long threadId;

    public RemoveRequest() {
    }

    public RemoveRequest(String name, Data key, Data value, long threadId) {
        super(name, key);
        this.value = value;
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        return new RemoveOperation(this.name, this.key, this.threadId, this.value);
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeLong("t", this.threadId);
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.threadId = reader.readLong("t");
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.value = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "remove");
    }

    @Override
    public String getMethodName() {
        return "remove";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.value};
    }
}

