/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapRemoveInterceptorCodec;
import com.hazelcast.client.impl.protocol.task.AbstractMultiTargetMessageTask;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.map.impl.operation.RemoveInterceptorOperationFactory;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class MapRemoveInterceptorMessageTask
extends AbstractMultiTargetMessageTask<MapRemoveInterceptorCodec.RequestParameters> {
    public MapRemoveInterceptorMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new RemoveInterceptorOperationFactory(((MapRemoveInterceptorCodec.RequestParameters)this.parameters).id, ((MapRemoveInterceptorCodec.RequestParameters)this.parameters).name);
    }

    @Override
    protected Object reduce(Map<Address, Object> map) throws Throwable {
        for (Object result : map.values()) {
            if (!(result instanceof Throwable)) continue;
            throw (Throwable)result;
        }
        return true;
    }

    @Override
    public Collection<Address> getTargets() {
        Collection<MemberImpl> memberList = this.nodeEngine.getClusterService().getMemberList();
        HashSet<Address> addresses = new HashSet<Address>();
        for (MemberImpl member : memberList) {
            addresses.add(member.getAddress());
        }
        return addresses;
    }

    @Override
    protected MapRemoveInterceptorCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapRemoveInterceptorCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapRemoveInterceptorCodec.encodeResponse((Boolean)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapRemoveInterceptorCodec.RequestParameters)this.parameters).name, "intercept");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapRemoveInterceptorCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "removeInterceptor";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapRemoveInterceptorCodec.RequestParameters)this.parameters).id};
    }
}

