/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.NistSipMessageHandlerImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;
import javax.sip.TransactionState;

public class NistSipMessageFactoryImpl
implements StackMessageFactory {
    SipStackImpl sipStackImpl;

    public ServerRequestInterface newSIPServerRequest(SIPRequest sipRequest, MessageChannel messageChannel) {
        if (messageChannel == null || sipRequest == null) {
            throw new IllegalArgumentException("Null Arg!");
        }
        NistSipMessageHandlerImpl retval = new NistSipMessageHandlerImpl();
        if (messageChannel instanceof SIPTransaction) {
            retval.transactionChannel = (SIPTransaction)messageChannel;
        }
        SIPTransactionStack theStack = (SIPTransactionStack)messageChannel.getSIPStack();
        retval.sipStackImpl = (SipStackImpl)theStack;
        retval.listeningPoint = messageChannel.getMessageProcessor().getListeningPoint();
        if (retval.listeningPoint == null) {
            return null;
        }
        if (LogWriter.needsLogging) {
            this.sipStackImpl.getLogWriter().logMessage("Returning request interface for " + sipRequest.getFirstLine() + " " + retval + " messageChannel = " + messageChannel);
        }
        return retval;
    }

    public ServerResponseInterface newSIPServerResponse(SIPResponse sipResponse, MessageChannel messageChannel) {
        SIPTransactionStack theStack = (SIPTransactionStack)messageChannel.getSIPStack();
        SIPTransaction tr = theStack.findTransaction(sipResponse, false);
        if (LogWriter.needsLogging) {
            this.sipStackImpl.getLogWriter().logMessage("Found Transaction " + tr + " for " + sipResponse);
        }
        if (tr != null) {
            if (tr.getState() == null) {
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("Dropping response - null transaction state");
                }
                return null;
            }
            if (TransactionState.COMPLETED == tr.getState() && sipResponse.getStatusCode() / 100 == 1) {
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("Dropping response - late arriving " + sipResponse.getStatusCode());
                }
                return null;
            }
        }
        NistSipMessageHandlerImpl retval = new NistSipMessageHandlerImpl();
        retval.sipStackImpl = (SipStackImpl)theStack;
        retval.transactionChannel = tr;
        retval.listeningPoint = messageChannel.getMessageProcessor().getListeningPoint();
        return retval;
    }

    public NistSipMessageFactoryImpl(SipStackImpl sipStackImpl) {
        this.sipStackImpl = sipStackImpl;
    }
}

