/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pl.mn.communicator.LocalUser;
import pl.mn.communicator.packet.in.GGIncomingPackage;

public class GGUserListReply
implements GGIncomingPackage {
    public static final int GG_USERLIST_REPLY = 16;
    private static final int GG_USERLIST_PUT_REPLY = 0;
    private static final int GG_USERLIST_PUT_MORE_REPLY = 2;
    private static final int GG_USERLIST_GET_MORE_REPLY = 4;
    private static final int GG_USERLIST_GET_REPLY = 6;
    private byte m_type = (byte)-1;
    private Collection m_users = null;

    public GGUserListReply(byte[] data) throws IOException {
        this.m_type = data[0];
        if (this.isGetMoreReply() || this.isGetReply()) {
            this.m_users = this.createUsersCollection(data);
        }
    }

    public int getPacketType() {
        return 0;
    }

    private Collection createUsersCollection(byte[] data) throws IOException {
        ArrayList<LocalUser> localUsers = new ArrayList<LocalUser>();
        String contactListString = new String(data, 1, data.length - 1, "windows-1250");
        BufferedReader bufReader = new BufferedReader(new StringReader(contactListString));
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            lines.add(line);
        }
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            String subline = (String)it.next();
            String[] contactListStrings = subline.split(";");
            List<String> contactList = Arrays.asList(contactListStrings);
            LocalUser localUser = this.createLocalUser(contactList);
            localUsers.add(localUser);
        }
        return localUsers;
    }

    private LocalUser createLocalUser(List entries) {
        String firstName = null;
        String lastName = null;
        String nickName = null;
        String displayName = null;
        String telephone = null;
        String group = null;
        String uin = null;
        String email = null;
        Iterator it = entries.iterator();
        if (it.hasNext()) {
            firstName = (String)it.next();
        }
        if (it.hasNext()) {
            lastName = (String)it.next();
        }
        if (it.hasNext()) {
            nickName = (String)it.next();
        }
        if (it.hasNext()) {
            displayName = (String)it.next();
        }
        if (it.hasNext()) {
            telephone = (String)it.next();
        }
        if (it.hasNext()) {
            group = (String)it.next();
        }
        if (it.hasNext()) {
            uin = (String)it.next();
        }
        if (it.hasNext()) {
            email = (String)it.next();
        }
        LocalUser localUser = new LocalUser();
        if (!this.isEmpty(firstName)) {
            localUser.setFirstName(firstName);
        }
        if (!this.isEmpty(lastName)) {
            localUser.setLastName(lastName);
        }
        if (!this.isEmpty(nickName)) {
            localUser.setNickName(nickName);
        }
        if (!this.isEmpty(displayName)) {
            localUser.setDisplayName(displayName);
        }
        if (!this.isEmpty(telephone)) {
            localUser.setTelephone(telephone);
        }
        if (!this.isEmpty(group)) {
            localUser.setGroup(group);
        }
        int uinInt = -1;
        try {
            uinInt = Integer.valueOf(uin);
            if (uinInt != -1 && !this.isEmpty(uin)) {
                localUser.setUin(uinInt);
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (!this.isEmpty(email)) {
            localUser.setEmailAddress(email);
        }
        return localUser;
    }

    public Collection getContactList() {
        return this.m_users;
    }

    public boolean isPutReply() {
        return this.m_type == 0;
    }

    public boolean isPutMoreReply() {
        return this.m_type == 2;
    }

    public boolean isGetReply() {
        return this.m_type == 6;
    }

    public boolean isGetMoreReply() {
        return this.m_type == 4;
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().equals("");
    }
}

