/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import pl.mn.communicator.AbstractChat;
import pl.mn.communicator.GGException;
import pl.mn.communicator.IChat;
import pl.mn.communicator.IIncommingMessage;
import pl.mn.communicator.ISingleChat;
import pl.mn.communicator.MessageStatus;
import pl.mn.communicator.OutgoingMessage;
import pl.mn.communicator.Session;

public class SingleChat
extends AbstractChat
implements ISingleChat {
    private int m_recipientUin = -1;

    SingleChat(Session session, int recipientUin) {
        super(session);
        if (recipientUin < 0) {
            throw new IllegalArgumentException("recipientUin cannot be less than 0");
        }
        this.m_recipientUin = recipientUin;
    }

    public IChat sendMessage(String messageBody) throws GGException {
        if (messageBody == null) {
            throw new NullPointerException("messageBody cannot be less than 0");
        }
        this.m_session.getMessageService().sendMessage(OutgoingMessage.createChatMessage(this.m_recipientUin, messageBody));
        return this;
    }

    public int getRecipientUin() {
        return this.m_recipientUin;
    }

    public void setRecipientUin(int recipientUin) {
        if (recipientUin < 0) {
            throw new IllegalArgumentException("recipientUin cannot be null");
        }
        this.m_recipientUin = recipientUin;
    }

    protected boolean acceptsIncoming(IIncommingMessage incomingMessage) {
        return incomingMessage.getRecipientUin() == this.m_recipientUin;
    }

    protected boolean acceptsOutgoing(int uin, int messageID, MessageStatus deliveryStatus) {
        return uin == this.m_recipientUin;
    }
}

