/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public abstract class AbstractRvIcbm
extends AbstractIcbm {
    public static final int RVSTATUS_REQUEST = 0;
    public static final int RVSTATUS_ACCEPT = 2;
    public static final int RVSTATUS_DENY = 1;
    private static final int TYPE_RV_DATA = 5;
    private int status;
    private long rvSessionId;
    private CapabilityBlock cap;
    private ByteBlock rvData;
    private LiveWritable rvDataWriter;

    protected AbstractRvIcbm(int command, SnacPacket packet) {
        super(4, command, packet);
    }

    final void processRvTlvs(TlvChain chain) {
        DefensiveTools.checkNull((Object)chain, (String)"chain");
        Tlv rvDataTlv = chain.getLastTlv(5);
        if (rvDataTlv == null) {
            this.status = -1;
            this.rvSessionId = 0L;
            this.cap = null;
            this.rvData = null;
            this.rvDataWriter = null;
        } else {
            ByteBlock rvBlock = rvDataTlv.getData();
            this.status = BinaryTools.getUShort((ByteBlock)rvBlock, (int)0);
            this.rvSessionId = BinaryTools.getLong((ByteBlock)rvBlock, (int)2);
            if (rvBlock.getLength() >= 26) {
                ByteBlock capBlock = rvBlock.subBlock(10, 16);
                this.cap = new CapabilityBlock(capBlock);
                this.rvData = rvBlock.subBlock(26);
            } else {
                this.cap = null;
                this.rvData = null;
            }
            this.rvDataWriter = this.rvData;
        }
    }

    protected AbstractRvIcbm(int command, long icbmMessageId, int status, long rvSessionId, CapabilityBlock cap, LiveWritable rvDataWriter) {
        super(4, command, icbmMessageId, 2);
        DefensiveTools.checkRange((int)status, (String)"status", (int)0);
        DefensiveTools.checkNull((Object)cap, (String)"cap");
        DefensiveTools.checkNull((Object)rvDataWriter, (String)"rvDataWriter");
        this.status = status;
        this.rvSessionId = rvSessionId;
        this.cap = cap;
        this.rvData = null;
        this.rvDataWriter = rvDataWriter;
    }

    protected AbstractRvIcbm(int command, long icbmMessageId, long rvSessionId, final RvCommand rvCommand) {
        this(command, icbmMessageId, rvCommand.getRvStatus(), rvSessionId, rvCommand.getCapabilityBlock(), new LiveWritable(){

            public void write(OutputStream out) throws IOException {
                rvCommand.writeRvData(out);
            }
        });
    }

    public final int getRvStatus() {
        return this.status;
    }

    public final long getRvSessionId() {
        return this.rvSessionId;
    }

    public final CapabilityBlock getCapability() {
        return this.cap;
    }

    public final ByteBlock getRvData() {
        return this.rvData;
    }

    final void writeRvTlvs(OutputStream out) throws IOException {
        ByteArrayOutputStream rvout = new ByteArrayOutputStream();
        BinaryTools.writeUShort((OutputStream)rvout, (int)this.status);
        BinaryTools.writeLong((OutputStream)rvout, (long)this.rvSessionId);
        this.cap.write(rvout);
        this.rvDataWriter.write((OutputStream)rvout);
        new Tlv(5, (Writable)ByteBlock.wrap((byte[])rvout.toByteArray())).write(out);
    }

    public String toString() {
        return "AbstractRvIcbm: status=" + this.status + ", rvSessionId=" + this.rvSessionId + ", on top of " + super.toString();
    }
}

