/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.net;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.net.ClientConnEvent;
import net.kano.joscar.net.ClientConnListener;
import net.kano.joscar.net.ClientConnStreamHandler;
import net.kano.joscar.net.ConnDescriptor;

public class ClientConn {
    public static final State STATE_NOT_CONNECTED = new State("NOT_CONNECTED");
    public static final State STATE_INITING = new State("INITING");
    public static final State STATE_RESOLVING = new State("RESOLVING");
    public static final State STATE_CONNECTING = new State("CONNECTING");
    public static final State STATE_CONNECTED = new State("CONNECTED");
    public static final State STATE_FAILED = new State("FAILED");
    public static final String REASON_ON_PURPOSE = "ON_PURPOSE";
    public static final String REASON_CONN_CLOSED = "CONN_CLOSED";
    private State state = STATE_NOT_CONNECTED;
    private final String host;
    private final InetAddress ip;
    private final int port;
    private CopyOnWriteArrayList<ClientConnListener> connListeners = new CopyOnWriteArrayList();
    private SocketFactory socketFactory = null;
    private Socket socket = null;
    private ConnectionThread connThread = null;
    private ClientConnStreamHandler streamHandler = null;

    public ClientConn(ConnDescriptor cd) {
        DefensiveTools.checkNull((Object)cd, (String)"cd");
        this.host = cd.getHost();
        this.ip = cd.getAddress();
        this.port = cd.getPort();
    }

    public final void addConnListener(ClientConnListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        this.connListeners.addIfAbsent((Object)l);
    }

    public final void removeConnListener(ClientConnListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        this.connListeners.remove((Object)l);
    }

    public final synchronized Socket getSocket() {
        return this.socket;
    }

    public final synchronized String getHost() {
        return this.host;
    }

    public final synchronized InetAddress getIpAddress() {
        return this.ip;
    }

    public final synchronized int getPort() {
        return this.port;
    }

    public final synchronized State getState() {
        return this.state;
    }

    private synchronized void setState(State state, Serializable reason) {
        if (this.state == state || this.state == STATE_FAILED && state == STATE_NOT_CONNECTED) {
            return;
        }
        State oldState = this.state;
        this.state = state;
        ClientConnEvent event = new ClientConnEvent(this, oldState, this.state, reason);
        for (ClientConnListener listener : this.connListeners) {
            listener.stateChanged(event);
        }
    }

    private synchronized void setSocket(Socket socket) {
        this.socket = socket;
    }

    public final synchronized void connect() throws IllegalStateException {
        if (this.state != STATE_NOT_CONNECTED && this.state != STATE_FAILED) {
            throw new IllegalStateException("I am already connected/connecting");
        }
        if (this.host == null && this.ip == null) {
            throw new IllegalStateException("either host or ip must be non-null");
        }
        if (this.host != null && this.ip != null) {
            throw new IllegalStateException("host and ip may not both be non-null");
        }
        if (this.port == -1) {
            throw new IllegalStateException("port must not be -1");
        }
        this.setState(STATE_INITING, null);
        Object dest = this.host == null ? this.ip : this.host;
        this.connThread = new ConnectionThread(MiscTools.getClassName(this) + " to " + dest + ":" + this.port);
        try {
            this.connThread.start();
        }
        catch (Throwable t) {
            this.setState(STATE_FAILED, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void processError(IOException o) {
        DefensiveTools.checkNull((Object)o, (String)"o");
        if (this.state == STATE_NOT_CONNECTED || this.state == STATE_FAILED) {
            return;
        }
        try {
            this.closeConn();
        }
        finally {
            this.setState(STATE_NOT_CONNECTED, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void disconnect() {
        if (this.state == STATE_NOT_CONNECTED || this.state == STATE_FAILED) {
            return;
        }
        try {
            this.closeConn();
        }
        finally {
            this.setState(STATE_NOT_CONNECTED, (Serializable)((Object)REASON_ON_PURPOSE));
        }
    }

    private synchronized void closeConn() {
        if (this.connThread != null) {
            this.connThread.cancel();
            this.connThread = null;
        }
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final synchronized void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public final synchronized SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public final synchronized void setStreamHandler(ClientConnStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
    }

    public final synchronized ClientConnStreamHandler getStreamHandler() {
        return this.streamHandler;
    }

    private Socket createSocket(InetAddress host, int port) throws IOException {
        SocketFactory factory = this.getSocketFactory();
        if (factory != null) {
            return factory.createSocket(host, port);
        }
        return new Socket(host, port);
    }

    public String toString() {
        return "ClientConn: state=" + this.state + ", socket=" + this.socket;
    }

    public static final class State {
        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ConnectionThread
    extends Thread {
        private volatile boolean cancelled;

        private ConnectionThread(String name) {
            super(name);
            this.cancelled = false;
        }

        public void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Socket socket;
            ClientConn conn;
            ClientConn clientConn = conn = ClientConn.this;
            // MONITORENTER : clientConn
            InetAddress ip = conn.ip;
            String host = conn.host;
            // MONITOREXIT : clientConn
            if (ip == null) {
                clientConn = conn;
                // MONITORENTER : clientConn
                if (this.cancelled) {
                    // MONITOREXIT : clientConn
                    return;
                }
                ClientConn.this.setState(STATE_RESOLVING, null);
                // MONITOREXIT : clientConn
                try {
                    ip = InetAddress.getByName(host);
                }
                catch (UnknownHostException e) {
                    ClientConn clientConn2 = conn;
                    // MONITORENTER : clientConn2
                    if (this.cancelled) {
                        // MONITOREXIT : clientConn2
                        return;
                    }
                    ClientConn.this.setState(STATE_FAILED, e);
                    // MONITOREXIT : clientConn2
                    return;
                }
            }
            ClientConn clientConn3 = conn;
            // MONITORENTER : clientConn3
            if (this.cancelled) {
                // MONITOREXIT : clientConn3
                return;
            }
            ClientConn.this.setState(STATE_CONNECTING, null);
            int port = conn.port;
            // MONITOREXIT : clientConn3
            try {
                socket = ClientConn.this.createSocket(ip, port);
            }
            catch (IOException e) {
                ClientConn clientConn4 = conn;
                // MONITORENTER : clientConn4
                if (this.cancelled) {
                    // MONITOREXIT : clientConn4
                    return;
                }
                ClientConn.this.setState(STATE_FAILED, e);
                // MONITOREXIT : clientConn4
                return;
            }
            ClientConn e = conn;
            // MONITORENTER : e
            if (this.cancelled) {
                // MONITOREXIT : e
                return;
            }
            ClientConn.this.setSocket(socket);
            ClientConn.this.setState(STATE_CONNECTED, null);
            // MONITOREXIT : e
            try {
                e = conn;
                // MONITORENTER : e
                if (this.cancelled) {
                    // MONITOREXIT : e
                    return;
                }
                // MONITOREXIT : e
                ClientConn.this.getStreamHandler().handleStream(ClientConn.this, socket);
                return;
            }
            catch (IOException e2) {
                ClientConn ignored = conn;
                // MONITORENTER : ignored
                if (this.cancelled) {
                    // MONITOREXIT : ignored
                    return;
                }
                ClientConn.this.processError(e2);
                // MONITOREXIT : ignored
                return;
            }
            finally {
                ClientConn clientConn5 = conn;
            }
        }

        public String toString() {
            return "ClientConn.ConnectionThread for " + ClientConn.this;
        }
    }
}

