/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpServer;
import org.mortbay.http.nio.ByteBufferInputStream;
import org.mortbay.http.nio.SocketChannelOutputStream;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.ThreadPool;

public class SocketChannelListener
extends ThreadPool
implements HttpListener {
    private static Log log = LogFactory.getLog(class$org$mortbay$http$nio$SocketChannelListener == null ? (class$org$mortbay$http$nio$SocketChannelListener = SocketChannelListener.class$("org.mortbay.http.nio.SocketChannelListener")) : class$org$mortbay$http$nio$SocketChannelListener);
    private InetSocketAddress _address;
    private int _bufferSize = 4096;
    private int _bufferReserve = 512;
    private int _sslPort;
    private int _lingerTimeSecs = 5;
    private HttpHandler _handler;
    private transient HttpServer _server;
    private transient ServerSocketChannel _acceptChannel;
    private transient Selector _selector;
    private transient SelectorThread _selectorThread;
    private transient boolean _isLow = false;
    private transient boolean _isOut = false;
    private transient long _warned = 0L;
    static /* synthetic */ Class class$org$mortbay$http$nio$SocketChannelListener;

    public void setHttpServer(HttpServer server) {
        this._server = server;
    }

    public HttpServer getHttpServer() {
        return this._server;
    }

    public void setHost(String host) throws UnknownHostException {
        this._address = new InetSocketAddress(host, this._address == null ? 0 : this._address.getPort());
    }

    public String getHost() {
        if (this._address == null || this._address.getAddress() == null) {
            return null;
        }
        return this._address.getHostName();
    }

    public void setPort(int port) {
        this._address = this._address == null || this._address.getHostName() == null ? new InetSocketAddress(port) : new InetSocketAddress(this._address.getHostName(), port);
    }

    public int getPort() {
        if (this._address == null) {
            return 0;
        }
        return this._address.getPort();
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferReserve(int size) {
        this._bufferReserve = size;
    }

    public int getBufferReserve() {
        return this._bufferReserve;
    }

    public String getDefaultScheme() {
        return "http";
    }

    public void customizeRequest(HttpConnection connection, HttpRequest request) {
    }

    public void persistConnection(HttpConnection connection) {
    }

    public boolean isLowOnResources() {
        boolean low;
        boolean bl = low = this.getMaxThreads() - this.getThreads() + this.getIdleThreads() < this.getMinThreads();
        if (low && !this._isLow) {
            log.info((Object)("LOW ON THREADS ((" + this.getMaxThreads() + "-" + this.getThreads() + "+" + this.getIdleThreads() + ")<" + this.getMinThreads() + ") on " + this));
            this._warned = System.currentTimeMillis();
            this._isLow = true;
        } else if (!low && this._isLow && System.currentTimeMillis() - this._warned > 1000L) {
            this._isOut = false;
            this._isLow = false;
        }
        return low;
    }

    public boolean isOutOfResources() {
        boolean out;
        boolean bl = out = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() == 0;
        if (out && !this._isOut) {
            log.warn((Object)("OUT OF THREADS: " + this));
            this._warned = System.currentTimeMillis();
            this._isLow = true;
            this._isOut = true;
        }
        return out;
    }

    public int getSslPort() {
        return this._sslPort;
    }

    public void setSslPort(int p) {
        this._sslPort = p;
    }

    public boolean isIntegral(HttpConnection connection) {
        return false;
    }

    public String getIntegralScheme() {
        return "https";
    }

    public int getIntegralPort() {
        return this._sslPort;
    }

    public boolean isConfidential(HttpConnection connection) {
        return false;
    }

    public String getConfidentialScheme() {
        return "https";
    }

    public int getConfidentialPort() {
        return this._sslPort;
    }

    public void setLingerTimeSecs(int ls) {
        this._lingerTimeSecs = ls;
    }

    public int getLingerTimeSecs() {
        return this._lingerTimeSecs;
    }

    public void setHttpHandler(HttpHandler handler) {
        this._handler = handler;
    }

    public HttpHandler getHttpHandler() {
        return this._handler;
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(false);
        this._acceptChannel.socket().bind(this._address);
        this._address = (InetSocketAddress)this._acceptChannel.socket().getLocalSocketAddress();
        this._selector = Selector.open();
        this._acceptChannel.register(this._selector, 16);
        this._selectorThread = new SelectorThread();
        this._selectorThread.start();
        super.start();
        log.info((Object)("Started SocketChannelListener on " + this.getHost() + ":" + this.getPort()));
    }

    public void stop() throws InterruptedException {
        if (this._selectorThread != null) {
            this._selectorThread.doStop();
        }
        super.stop();
        log.info((Object)("Stopped SocketChannelListener on " + this.getHost() + ":" + this.getPort()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Connection
    extends HttpConnection
    implements Runnable {
        boolean _idle = true;
        SocketChannel _channel;
        SelectionKey _key;
        ByteBufferInputStream _in;
        SocketChannelOutputStream _out;
        SocketChannelListener _listener;

        Connection(SocketChannel channel, SelectionKey key, SocketChannelListener listener) {
            super(listener, channel.socket().getInetAddress(), new ByteBufferInputStream(listener.getBufferSize()), new SocketChannelOutputStream(channel, listener.getBufferSize()), channel);
            this._channel = channel;
            this._key = key;
            this._listener = listener;
            this._in = (ByteBufferInputStream)((LineInput)this.getInputStream().getInputStream()).getInputStream();
            this._out = (SocketChannelOutputStream)this.getOutputStream().getOutputStream();
            this._in.setTimeout(listener.getMaxIdleTimeMs());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(ByteBuffer buf) {
            if (!this._idle) {
                this._in.write(buf);
            } else {
                boolean written = false;
                for (int i = buf.position(); i < buf.limit(); ++i) {
                    byte b = buf.get(i);
                    if (b <= 32) continue;
                    buf.position(i);
                    try {
                        written = true;
                        this._in.write(buf);
                        this._listener.run(this);
                        this._idle = false;
                        continue;
                    }
                    catch (InterruptedException e) {
                        LogSupport.ignore(log, e);
                        continue;
                    }
                    finally {
                        i = buf.limit();
                    }
                }
                if (!written) {
                    this._in.recycle(buf);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.associateThread();
                while (this._in != null && this._in.available() > 0 && this._listener.isStarted()) {
                    if (this.handleNext()) {
                        this.recycle();
                        continue;
                    }
                    this.destroy();
                }
            }
            catch (IOException e) {
                log.warn((Object)e.toString());
                log.debug((Object)e);
                this.destroy();
            }
            finally {
                this._idle = true;
                this.disassociateThread();
            }
        }

        public synchronized void close() throws IOException {
            this._out.close();
            this._in.close();
            if (!this._channel.isOpen()) {
                return;
            }
            this._key.cancel();
            this._channel.socket().shutdownOutput();
            this._channel.close();
            this._channel.socket().close();
            super.close();
            this._channel.close();
        }

        public void destroy() {
            super.destroy();
            if (this._in != null) {
                this._in.destroy();
            }
            this._in = null;
            if (this._out != null) {
                this._out.destroy();
            }
            this._out = null;
            this._channel = null;
            this._key = null;
            this._listener = null;
        }
    }

    private class SelectorThread
    extends Thread {
        boolean _running = false;

        private SelectorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block20: {
                try {
                    this._running = true;
                    while (this._running) {
                        SelectionKey key = null;
                        try {
                            SocketChannelListener.this._selector.select();
                            Iterator<SelectionKey> iter = SocketChannelListener.this._selector.selectedKeys().iterator();
                            while (iter.hasNext()) {
                                key = iter.next();
                                if (key.isAcceptable()) {
                                    this.doAccept(key);
                                }
                                if (key.isReadable()) {
                                    this.doRead(key);
                                }
                                key = null;
                                iter.remove();
                            }
                        }
                        catch (Exception e) {
                            if (this._running) {
                                log.warn((Object)"selector", (Throwable)e);
                            }
                            if (key == null) continue;
                            key.cancel();
                        }
                    }
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    log.info((Object)("Stopping " + this.getName()));
                    try {
                        if (SocketChannelListener.this._acceptChannel != null) {
                            SocketChannelListener.this._acceptChannel.close();
                        }
                    }
                    catch (IOException e) {
                        LogSupport.ignore(log, e);
                    }
                    try {
                        if (SocketChannelListener.this._selector != null) {
                            SocketChannelListener.this._selector.close();
                        }
                    }
                    catch (IOException e) {
                        LogSupport.ignore(log, e);
                    }
                    SocketChannelListener.this._selector = null;
                    SocketChannelListener.this._acceptChannel = null;
                    SocketChannelListener.this._selectorThread = null;
                    throw throwable;
                }
                log.info((Object)("Stopping " + this.getName()));
                try {
                    if (SocketChannelListener.this._acceptChannel != null) {
                        SocketChannelListener.this._acceptChannel.close();
                    }
                }
                catch (IOException e) {
                    LogSupport.ignore(log, e);
                }
                try {
                    if (SocketChannelListener.this._selector != null) {
                        SocketChannelListener.this._selector.close();
                    }
                    break block20;
                }
                catch (IOException e) {
                    LogSupport.ignore(log, e);
                }
                {
                }
            }
            SocketChannelListener.this._selector = null;
            SocketChannelListener.this._acceptChannel = null;
            SocketChannelListener.this._selectorThread = null;
        }

        void doAccept(SelectionKey key) throws IOException, InterruptedException {
            if (SocketChannelListener.this.isLowOnResources()) {
                return;
            }
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = server.accept();
            channel.configureBlocking(false);
            SelectionKey readKey = channel.register(SocketChannelListener.this._selector, 1);
            Socket socket = channel.socket();
            try {
                if (SocketChannelListener.this.getMaxIdleTimeMs() >= 0) {
                    socket.setSoTimeout(SocketChannelListener.this.getMaxIdleTimeMs());
                }
                if (SocketChannelListener.this._lingerTimeSecs >= 0) {
                    socket.setSoLinger(true, SocketChannelListener.this._lingerTimeSecs);
                } else {
                    socket.setSoLinger(false, 0);
                }
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
            }
            Connection connection = new Connection(channel, readKey, SocketChannelListener.this);
            readKey.attach(connection);
        }

        void doRead(SelectionKey key) throws IOException {
            Connection connection = (Connection)key.attachment();
            if (connection._idle && SocketChannelListener.this.isOutOfResources()) {
                return;
            }
            ByteBuffer buf = connection._in.getBuffer();
            int count = ((SocketChannel)key.channel()).read(buf);
            if (count < 0) {
                connection.close();
            } else {
                buf.flip();
                connection.write(buf);
            }
        }

        void doStop() {
            this._running = false;
            SocketChannelListener.this._selector.wakeup();
            Thread.yield();
        }
    }
}

