/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jml.message.MsnControlMessage;
import net.sf.jml.message.MsnDatacastMessage;
import net.sf.jml.message.MsnInstantMessage;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.message.MsnSystemMessage;
import net.sf.jml.message.MsnUnknownMessage;
import net.sf.jml.message.invitation.MsnInvitationMessageFactory;
import net.sf.jml.message.p2p.MsnP2PMessageFactory;
import net.sf.jml.util.Charset;

class MsnMimeMessageFactory {
    private static Pattern pattern = Pattern.compile("Content-Type:\\s*(.*)\r\n");
    private static Map map = new LinkedHashMap();

    private MsnMimeMessageFactory() {
    }

    public static MsnMimeMessage parseMessage(byte[] byArray) throws Exception {
        String string = Charset.decode(byArray);
        String string2 = MsnMimeMessageFactory.getContentType(string);
        MsnMimeMessage msnMimeMessage = MsnMimeMessageFactory.parseSpecialMessage(string2, byArray, string);
        if (msnMimeMessage == null) {
            msnMimeMessage = (MsnMimeMessage)MsnMimeMessageFactory.getMessageClass(string2).newInstance();
        }
        msnMimeMessage.parseMessage(byArray);
        return msnMimeMessage;
    }

    private static String getContentType(String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private static MsnMimeMessage parseSpecialMessage(String string, byte[] byArray, String string2) {
        if (string.startsWith("text/x-msmsgsinvite")) {
            return MsnInvitationMessageFactory.parseMessage(string2);
        }
        if (string.startsWith("application/x-msnmsgrp2p")) {
            return MsnP2PMessageFactory.parseMessage(byArray);
        }
        return null;
    }

    private static Class getMessageClass(String string) {
        Class clazz = (Class)map.get(string);
        if (clazz == null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!string.startsWith((String)entry.getKey())) continue;
                return (Class)entry.getValue();
            }
        }
        return clazz;
    }

    static {
        map.put("text/plain", MsnInstantMessage.class);
        map.put("text/x-msmsgscontrol", MsnControlMessage.class);
        map.put("text/x-msnmsgr-datacast", MsnDatacastMessage.class);
        map.put("text/x-msmsgsprofile", MsnSystemMessage.class);
        map.put("text/x-msmsgsinitialmdatanotification", MsnSystemMessage.class);
        map.put("text/x-msmsgsinitialemailnotification", MsnSystemMessage.class);
        map.put("text/x-msmsgsemailnotification", MsnSystemMessage.class);
        map.put("text/x-msmsgsactivemailnotification", MsnSystemMessage.class);
        map.put("application/x-msmsgssystemmessage", MsnSystemMessage.class);
        map.put("", MsnUnknownMessage.class);
    }
}

