/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.math.ec.ECConstants;

public abstract class ECFieldElement
implements ECConstants {
    BigInteger x;

    protected ECFieldElement(BigInteger bigInteger) {
        this.x = bigInteger;
    }

    public BigInteger toBigInteger() {
        return this.x;
    }

    public abstract String getFieldName();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement square();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement sqrt();

    public static class F2m
    extends ECFieldElement {
        public static final int GNB = 1;
        public static final int TPB = 2;
        public static final int PPB = 3;
        private int representation;
        private int m;
        private int k1;
        private int k2;
        private int k3;

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger) {
            super(bigInteger);
            if (n3 == 0 && n4 == 0) {
                this.representation = 2;
            } else {
                if (n3 >= n4) {
                    throw new IllegalArgumentException("k2 must be smaller than k3");
                }
                if (n3 <= 0) {
                    throw new IllegalArgumentException("k2 must be larger than 0");
                }
                this.representation = 3;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException("x value cannot be negative");
            }
            this.m = n;
            this.k1 = n2;
            this.k2 = n3;
            this.k3 = n4;
        }

        public F2m(int n, int n2, BigInteger bigInteger) {
            this(n, n2, 0, 0, bigInteger);
        }

        public String getFieldName() {
            return "F2m";
        }

        public static void checkFieldElements(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            if (!(eCFieldElement instanceof F2m) || !(eCFieldElement2 instanceof F2m)) {
                throw new IllegalArgumentException("Field elements are not both instances of ECFieldElement.F2m");
            }
            if (eCFieldElement.x.signum() < 0 || eCFieldElement2.x.signum() < 0) {
                throw new IllegalArgumentException("x value may not be negative");
            }
            F2m f2m = (F2m)eCFieldElement;
            F2m f2m2 = (F2m)eCFieldElement2;
            if (f2m.m != f2m2.m || f2m.k1 != f2m2.k1 || f2m.k2 != f2m2.k2 || f2m.k3 != f2m2.k3) {
                throw new IllegalArgumentException("Field elements are not elements of the same field F2m");
            }
            if (f2m.representation != f2m2.representation) {
                throw new IllegalArgumentException("One of the field elements are not elements has incorrect representation");
            }
        }

        private BigInteger multZModF(BigInteger bigInteger) {
            BigInteger bigInteger2 = bigInteger.shiftLeft(1);
            if (bigInteger2.testBit(this.m)) {
                bigInteger2 = bigInteger2.clearBit(this.m);
                bigInteger2 = bigInteger2.flipBit(0);
                bigInteger2 = bigInteger2.flipBit(this.k1);
                if (this.representation == 3) {
                    bigInteger2 = bigInteger2.flipBit(this.k2);
                    bigInteger2 = bigInteger2.flipBit(this.k3);
                }
            }
            return bigInteger2;
        }

        public ECFieldElement add(ECFieldElement eCFieldElement) {
            return new F2m(this.m, this.k1, this.k2, this.k3, this.x.xor(eCFieldElement.x));
        }

        public ECFieldElement subtract(ECFieldElement eCFieldElement) {
            return this.add(eCFieldElement);
        }

        public ECFieldElement multiply(ECFieldElement eCFieldElement) {
            BigInteger bigInteger = this.x;
            BigInteger bigInteger2 = eCFieldElement.x;
            BigInteger bigInteger3 = bigInteger.testBit(0) ? bigInteger2 : ECConstants.ZERO;
            for (int i = 1; i < this.m; ++i) {
                bigInteger2 = this.multZModF(bigInteger2);
                if (!bigInteger.testBit(i)) continue;
                bigInteger3 = bigInteger3.xor(bigInteger2);
            }
            return new F2m(this.m, this.k1, this.k2, this.k3, bigInteger3);
        }

        public ECFieldElement divide(ECFieldElement eCFieldElement) {
            ECFieldElement eCFieldElement2 = eCFieldElement.invert();
            return this.multiply(eCFieldElement2);
        }

        public ECFieldElement negate() {
            return new F2m(this.m, this.k1, this.k2, this.k3, this.x);
        }

        public ECFieldElement square() {
            return this.multiply(this);
        }

        public ECFieldElement invert() {
            BigInteger bigInteger = this.x;
            if (bigInteger.signum() <= 0) {
                throw new ArithmeticException("x is zero or negative, inversion is impossible");
            }
            BigInteger bigInteger2 = ECConstants.ONE.shiftLeft(this.m);
            bigInteger2 = bigInteger2.setBit(0);
            bigInteger2 = bigInteger2.setBit(this.k1);
            if (this.representation == 3) {
                bigInteger2 = bigInteger2.setBit(this.k2);
                bigInteger2 = bigInteger2.setBit(this.k3);
            }
            BigInteger bigInteger3 = ECConstants.ONE;
            BigInteger bigInteger4 = ECConstants.ZERO;
            while (!bigInteger.equals(ECConstants.ZERO)) {
                int n = bigInteger.bitLength() - bigInteger2.bitLength();
                if (n < 0) {
                    BigInteger bigInteger5 = bigInteger;
                    bigInteger = bigInteger2;
                    bigInteger2 = bigInteger5;
                    BigInteger bigInteger6 = bigInteger3;
                    bigInteger3 = bigInteger4;
                    bigInteger4 = bigInteger6;
                    n = -n;
                }
                bigInteger = bigInteger.xor(bigInteger2.shiftLeft(n));
                bigInteger3 = bigInteger3.xor(bigInteger4.shiftLeft(n));
            }
            return new F2m(this.m, this.k1, this.k2, this.k3, bigInteger4);
        }

        public ECFieldElement sqrt() {
            throw new RuntimeException("Not implemented");
        }

        public int getRepresentation() {
            return this.representation;
        }

        public int getM() {
            return this.m;
        }

        public int getK1() {
            return this.k1;
        }

        public int getK2() {
            return this.k2;
        }

        public int getK3() {
            return this.k3;
        }

        public String toString() {
            return this.x.toString(2);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)object;
            return this.m == f2m.m && this.k1 == f2m.k1 && this.k2 == f2m.k2 && this.k3 == f2m.k3 && this.representation == f2m.representation && this.x.equals(f2m.x);
        }

        public int hashCode() {
            return this.x.hashCode() ^ this.m ^ this.k1 ^ this.k2 ^ this.k3;
        }
    }

    public static class Fp
    extends ECFieldElement {
        BigInteger q;

        public Fp(BigInteger bigInteger, BigInteger bigInteger2) {
            super(bigInteger2);
            if (bigInteger2.compareTo(bigInteger) >= 0) {
                throw new IllegalArgumentException("x value too large in field element");
            }
            this.q = bigInteger;
        }

        public String getFieldName() {
            return "Fp";
        }

        public BigInteger getQ() {
            return this.q;
        }

        public ECFieldElement add(ECFieldElement eCFieldElement) {
            return new Fp(this.q, this.x.add(eCFieldElement.x).mod(this.q));
        }

        public ECFieldElement subtract(ECFieldElement eCFieldElement) {
            return new Fp(this.q, this.x.subtract(eCFieldElement.x).mod(this.q));
        }

        public ECFieldElement multiply(ECFieldElement eCFieldElement) {
            return new Fp(this.q, this.x.multiply(eCFieldElement.x).mod(this.q));
        }

        public ECFieldElement divide(ECFieldElement eCFieldElement) {
            return new Fp(this.q, this.x.multiply(eCFieldElement.x.modInverse(this.q)).mod(this.q));
        }

        public ECFieldElement negate() {
            return new Fp(this.q, this.x.negate().mod(this.q));
        }

        public ECFieldElement square() {
            return new Fp(this.q, this.x.multiply(this.x).mod(this.q));
        }

        public ECFieldElement invert() {
            return new Fp(this.q, this.x.modInverse(this.q));
        }

        public ECFieldElement sqrt() {
            if (this.q.testBit(1)) {
                Fp fp = new Fp(this.q, this.x.modPow(this.q.shiftRight(2).add(ONE), this.q));
                return ((ECFieldElement)fp).square().equals(this) ? fp : null;
            }
            if (this.q.testBit(0)) {
                Random random = new Random();
                BigInteger bigInteger = this.q.subtract(ECConstants.ONE).divide(BigInteger.valueOf(2L));
                if (!this.x.modPow(bigInteger, this.q).equals(ECConstants.ONE)) {
                    return null;
                }
                BigInteger bigInteger2 = BigInteger.valueOf(4L).multiply(this.x);
                BigInteger bigInteger3 = new BigInteger(this.q.bitLength(), random).mod(this.q);
                bigInteger3 = BigInteger.valueOf(2L);
                while (!bigInteger3.multiply(bigInteger3).subtract(bigInteger2).modPow(bigInteger, this.q).equals(this.q.subtract(ECConstants.ONE))) {
                    bigInteger3 = new BigInteger(this.q.bitLength(), random).mod(this.q);
                }
                BigInteger bigInteger4 = this.q.subtract(ECConstants.ONE).divide(BigInteger.valueOf(4L));
                BigInteger bigInteger5 = this.q.add(BigInteger.valueOf(3L)).divide(BigInteger.valueOf(4L));
                BigInteger bigInteger6 = this.x.multiply(BigInteger.valueOf(2L).multiply(bigInteger3).modPow(this.q.subtract(BigInteger.valueOf(2L)), this.q)).multiply(this.W(bigInteger4, bigInteger3, this.x, this.q).add(this.W(bigInteger5, bigInteger3, this.x, this.q))).mod(this.q);
                return new Fp(this.q, bigInteger6);
            }
            throw new RuntimeException("not done yet");
        }

        private BigInteger W(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            if (bigInteger.equals(ECConstants.ONE)) {
                return bigInteger2.multiply(bigInteger2).multiply(bigInteger3.modPow(this.q.subtract(BigInteger.valueOf(2L)), this.q)).subtract(BigInteger.valueOf(2L)).mod(bigInteger4);
            }
            if (!bigInteger.testBit(0)) {
                BigInteger bigInteger5 = this.W(bigInteger.divide(BigInteger.valueOf(2L)), bigInteger2, bigInteger3, bigInteger4);
                return bigInteger5.multiply(bigInteger5).subtract(BigInteger.valueOf(2L)).mod(bigInteger4);
            }
            BigInteger bigInteger6 = this.W(bigInteger.add(ECConstants.ONE).divide(BigInteger.valueOf(2L)), bigInteger2, bigInteger3, bigInteger4);
            BigInteger bigInteger7 = this.W(bigInteger.subtract(ECConstants.ONE).divide(BigInteger.valueOf(2L)), bigInteger2, bigInteger3, bigInteger4);
            return bigInteger6.multiply(bigInteger7).subtract(this.W(ECConstants.ONE, bigInteger2, bigInteger3, bigInteger4)).mod(bigInteger4);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)object;
            return this.q.equals(fp.q) && this.x.equals(fp.x);
        }

        public int hashCode() {
            return this.q.hashCode() ^ this.x.hashCode();
        }
    }
}

