/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ssl;

import com.hazelcast.nio.DefaultSocketChannelWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;

public class SSLSocketChannelWrapper
extends DefaultSocketChannelWrapper {
    private static final boolean DEBUG = false;
    private final ByteBuffer in;
    private final ByteBuffer emptyBuffer;
    private final ByteBuffer netOutBuffer;
    private final ByteBuffer netInBuffer;
    private final SSLEngine sslEngine;
    private volatile boolean handshakeCompleted = false;
    private SSLEngineResult sslEngineResult;

    public SSLSocketChannelWrapper(SSLContext sslContext, SocketChannel sc, boolean client) throws Exception {
        super(sc);
        this.sslEngine = sslContext.createSSLEngine();
        this.sslEngine.setUseClientMode(client);
        this.sslEngine.setEnableSessionCreation(true);
        SSLSession session = this.sslEngine.getSession();
        this.in = ByteBuffer.allocate(65536);
        this.emptyBuffer = ByteBuffer.allocate(0);
        int netBufferMax = session.getPacketBufferSize();
        this.netOutBuffer = ByteBuffer.allocate(netBufferMax);
        this.netInBuffer = ByteBuffer.allocate(netBufferMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshake() throws IOException {
        if (this.handshakeCompleted) {
            return;
        }
        SSLSocketChannelWrapper sSLSocketChannelWrapper = this;
        synchronized (sSLSocketChannelWrapper) {
            if (this.handshakeCompleted) {
                return;
            }
            int counter = 0;
            this.sslEngine.beginHandshake();
            this.writeInternal(this.emptyBuffer);
            while (counter++ < 250 && this.sslEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                if (this.sslEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    this.netInBuffer.clear();
                    while (this.socketChannel.read(this.netInBuffer) < 1) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            throw new IOException(e);
                        }
                    }
                    this.netInBuffer.flip();
                    this.unwrap(this.netInBuffer);
                    if (this.sslEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) continue;
                    this.emptyBuffer.clear();
                    this.writeInternal(this.emptyBuffer);
                    continue;
                }
                if (this.sslEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    this.emptyBuffer.clear();
                    this.writeInternal(this.emptyBuffer);
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            if (this.sslEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                throw new SSLHandshakeException("SSL handshake failed after " + counter + " trials! -> " + (Object)((Object)this.sslEngineResult.getHandshakeStatus()));
            }
            this.in.clear();
            this.in.flip();
            this.handshakeCompleted = true;
        }
    }

    private void log(String log) {
    }

    private ByteBuffer unwrap(ByteBuffer b) throws SSLException {
        this.in.clear();
        while (b.hasRemaining()) {
            this.sslEngineResult = this.sslEngine.unwrap(b, this.in);
            if (this.sslEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable task;
                while ((task = this.sslEngine.getDelegatedTask()) != null) {
                    task.run();
                }
                continue;
            }
            if (this.sslEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED && this.sslEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
            return this.in;
        }
        return this.in;
    }

    @Override
    public int write(ByteBuffer input) throws IOException {
        if (!this.handshakeCompleted) {
            this.handshake();
        }
        return this.writeInternal(input);
    }

    private int writeInternal(ByteBuffer input) throws IOException {
        this.sslEngineResult = this.sslEngine.wrap(input, this.netOutBuffer);
        this.netOutBuffer.flip();
        int written = this.socketChannel.write(this.netOutBuffer);
        if (this.netOutBuffer.hasRemaining()) {
            this.netOutBuffer.compact();
        } else {
            this.netOutBuffer.clear();
        }
        return written;
    }

    @Override
    public int read(ByteBuffer output) throws IOException {
        int i;
        int limit;
        if (!this.handshakeCompleted) {
            this.handshake();
        }
        int readBytesCount = 0;
        if (this.in.hasRemaining()) {
            int limit2 = Math.min(this.in.remaining(), output.remaining());
            for (int i2 = 0; i2 < limit2; ++i2) {
                output.put(this.in.get());
                ++readBytesCount;
            }
            return readBytesCount;
        }
        if (this.netInBuffer.hasRemaining()) {
            this.unwrap(this.netInBuffer);
            this.in.flip();
            limit = Math.min(this.in.remaining(), output.remaining());
            for (i = 0; i < limit; ++i) {
                output.put(this.in.get());
                ++readBytesCount;
            }
            if (this.sslEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.netInBuffer.clear();
                this.netInBuffer.flip();
                return readBytesCount;
            }
        }
        if (this.netInBuffer.hasRemaining()) {
            this.netInBuffer.compact();
        } else {
            this.netInBuffer.clear();
        }
        if (this.socketChannel.read(this.netInBuffer) == -1) {
            this.netInBuffer.clear();
            this.netInBuffer.flip();
            return -1;
        }
        this.netInBuffer.flip();
        this.unwrap(this.netInBuffer);
        this.in.flip();
        limit = Math.min(this.in.remaining(), output.remaining());
        for (i = 0; i < limit; ++i) {
            output.put(this.in.get());
            ++readBytesCount;
        }
        return readBytesCount;
    }

    @Override
    public void close() throws IOException {
        this.sslEngine.closeOutbound();
        try {
            this.writeInternal(this.emptyBuffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socketChannel.close();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SSLSocketChannelWrapper{");
        sb.append("socketChannel=").append(this.socketChannel);
        sb.append('}');
        return sb.toString();
    }
}

