/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.InputStream;
import java.util.Properties;

public class ClasspathXmlConfig
extends Config {
    private static final ILogger logger = Logger.getLogger(ClasspathXmlConfig.class);

    public ClasspathXmlConfig(String resource) {
        this(resource, System.getProperties());
    }

    public ClasspathXmlConfig(String resource, Properties properties) {
        this(Thread.currentThread().getContextClassLoader(), resource, properties);
    }

    public ClasspathXmlConfig(ClassLoader classLoader, String resource) {
        this(classLoader, resource, System.getProperties());
    }

    public ClasspathXmlConfig(ClassLoader classLoader, String resource, Properties properties) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader can't be null");
        }
        if (resource == null) {
            throw new IllegalArgumentException("resource can't be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties can't be null");
        }
        logger.info("Configuring Hazelcast from '" + resource + "'.");
        InputStream in = classLoader.getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException("Specified resource '" + resource + "' could not be found!");
        }
        new XmlConfigBuilder(in).setProperties(properties).build(this);
    }
}

