/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import net.java.sip.communicator.service.resources.ColorPack;
import net.java.sip.communicator.service.resources.ImagePack;
import net.java.sip.communicator.service.resources.LanguagePack;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.service.resources.ResourcePack;
import net.java.sip.communicator.service.resources.SettingsPack;
import net.java.sip.communicator.service.resources.SkinPack;
import net.java.sip.communicator.service.resources.SoundPack;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public abstract class AbstractResourcesService
implements ResourceManagementService,
ServiceListener {
    private static final Logger logger = Logger.getLogger(AbstractResourcesService.class);
    private BundleContext bundleContext;
    private Map<String, String> settingsResources;
    private ResourcePack settingsPack = null;
    private Map<String, String> languageResources;
    private LanguagePack languagePack = null;
    private Locale languageLocale;
    private Map<String, String> imageResources;
    private ImagePack imagePack = null;
    private Map<String, String> colorResources;
    private ResourcePack colorPack = null;
    private Map<String, String> soundResources;
    private ResourcePack soundPack = null;
    private SkinPack skinPack = null;

    public AbstractResourcesService(BundleContext bundleContext) {
        ConfigurationService confService;
        String defaultLocale;
        this.bundleContext = bundleContext;
        bundleContext.addServiceListener((ServiceListener)this);
        this.colorPack = this.getDefaultResourcePack(ColorPack.class.getName(), "DefaultColorPack");
        if (this.colorPack != null) {
            this.colorResources = this.getResources(this.colorPack);
        }
        this.imagePack = (ImagePack)this.getDefaultResourcePack(ImagePack.class.getName(), "DefaultImagePack");
        if (this.imagePack != null) {
            this.imageResources = this.getResources(this.imagePack);
        }
        if ((defaultLocale = (String)(confService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class)).getProperty("net.java.sip.communicator.service.resources.DefaultLocale")) != null) {
            Locale.setDefault(ResourceManagementServiceUtils.getLocale(defaultLocale));
        }
        this.languagePack = (LanguagePack)this.getDefaultResourcePack(LanguagePack.class.getName(), "DefaultLanguagePack");
        if (this.languagePack != null) {
            this.languageLocale = Locale.getDefault();
            this.languageResources = this.languagePack.getResources(this.languageLocale);
        }
        this.settingsPack = this.getDefaultResourcePack(SettingsPack.class.getName(), "DefaultSettingsPack");
        if (this.settingsPack != null) {
            this.settingsResources = this.getResources(this.settingsPack);
        }
        this.soundPack = this.getDefaultResourcePack(SoundPack.class.getName(), "DefaultSoundPack");
        if (this.soundPack != null) {
            this.soundResources = this.getResources(this.soundPack);
        }
        this.skinPack = (SkinPack)this.getDefaultResourcePack(SkinPack.class.getName(), "SkinPack");
        if (this.skinPack != null) {
            if (this.imageResources != null) {
                this.imageResources.putAll(this.skinPack.getImageResources());
            }
            this.colorResources.putAll(this.skinPack.getColorResources());
            this.settingsResources.putAll(this.skinPack.getSettingsResources());
        }
    }

    public void serviceChanged(ServiceEvent event) {
        Object sService = this.bundleContext.getService(event.getServiceReference());
        if (!(sService instanceof ResourcePack)) {
            return;
        }
        ResourcePack resourcePack = (ResourcePack)sService;
        if (event.getType() == 1) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Resource registered " + resourcePack));
            }
            Map<String, String> resources = this.getResources(resourcePack);
            if (resourcePack instanceof ColorPack && this.colorPack == null) {
                this.colorPack = resourcePack;
                this.colorResources = resources;
            } else if (resourcePack instanceof ImagePack && this.imagePack == null) {
                this.imagePack = (ImagePack)resourcePack;
                this.imageResources = resources;
            } else if (resourcePack instanceof LanguagePack && this.languagePack == null) {
                this.languagePack = (LanguagePack)resourcePack;
                this.languageLocale = Locale.getDefault();
                this.languageResources = resources;
            } else if (resourcePack instanceof SettingsPack && this.settingsPack == null) {
                this.settingsPack = resourcePack;
                this.settingsResources = resources;
            } else if (resourcePack instanceof SoundPack && this.soundPack == null) {
                this.soundPack = resourcePack;
                this.soundResources = resources;
            } else if (resourcePack instanceof SkinPack && this.skinPack == null) {
                this.skinPack = (SkinPack)resourcePack;
                if (this.imagePack != null) {
                    this.imageResources = this.getResources(this.imagePack);
                }
                if (this.colorPack != null) {
                    this.colorResources = this.getResources(this.colorPack);
                }
                if (this.settingsPack != null) {
                    this.settingsResources = this.getResources(this.settingsPack);
                }
                if (this.imageResources != null) {
                    this.imageResources.putAll(this.skinPack.getImageResources());
                }
                this.colorResources.putAll(this.skinPack.getColorResources());
                this.settingsResources.putAll(this.skinPack.getSettingsResources());
                this.onSkinPackChanged();
            }
        } else if (event.getType() == 4) {
            if (resourcePack instanceof ColorPack && this.colorPack.equals(resourcePack)) {
                this.colorPack = this.getDefaultResourcePack(ColorPack.class.getName(), "DefaultColorPack");
                if (this.colorPack != null) {
                    this.colorResources = this.getResources(this.colorPack);
                }
            } else if (resourcePack instanceof ImagePack && this.imagePack.equals(resourcePack)) {
                this.imagePack = (ImagePack)this.getDefaultResourcePack(ImagePack.class.getName(), "DefaultImagePack");
                if (this.imagePack != null) {
                    this.imageResources = this.getResources(this.imagePack);
                }
            } else if (resourcePack instanceof LanguagePack && this.languagePack.equals(resourcePack)) {
                this.languagePack = (LanguagePack)this.getDefaultResourcePack(LanguagePack.class.getName(), "DefaultLanguagePack");
            } else if (resourcePack instanceof SettingsPack && this.settingsPack.equals(resourcePack)) {
                this.settingsPack = this.getDefaultResourcePack(SettingsPack.class.getName(), "DefaultSettingsPack");
                if (this.settingsPack != null) {
                    this.settingsResources = this.getResources(this.settingsPack);
                }
            } else if (resourcePack instanceof SoundPack && this.soundPack.equals(resourcePack)) {
                this.soundPack = this.getDefaultResourcePack(SoundPack.class.getName(), "DefaultSoundPack");
                if (this.soundPack != null) {
                    this.soundResources = this.getResources(this.soundPack);
                }
            } else if (resourcePack instanceof SkinPack && this.skinPack.equals(resourcePack)) {
                if (this.imagePack != null) {
                    this.imageResources = this.getResources(this.imagePack);
                }
                if (this.colorPack != null) {
                    this.colorResources = this.getResources(this.colorPack);
                }
                if (this.settingsPack != null) {
                    this.settingsResources = this.getResources(this.settingsPack);
                }
                this.skinPack = (SkinPack)this.getDefaultResourcePack(SkinPack.class.getName(), "SkinPack");
                if (this.skinPack != null) {
                    this.imageResources.putAll(this.skinPack.getImageResources());
                    this.colorResources.putAll(this.skinPack.getColorResources());
                    this.settingsResources.putAll(this.skinPack.getSettingsResources());
                }
                this.onSkinPackChanged();
            }
        }
    }

    protected abstract void onSkinPackChanged();

    protected ResourcePack getDefaultResourcePack(String className, String typeName) {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(ResourceName=" + typeName + ")";
        try {
            serRefs = this.bundleContext.getServiceReferences(className, osgiFilter);
        }
        catch (InvalidSyntaxException exc) {
            logger.error((Object)"Could not obtain resource packs reference.", (Throwable)exc);
        }
        if (serRefs != null && serRefs.length > 0) {
            return (ResourcePack)this.bundleContext.getService(serRefs[0]);
        }
        return null;
    }

    protected Map<String, String> getResources(ResourcePack resourcePack) {
        return resourcePack.getResources();
    }

    public Iterator<Locale> getAvailableLocales() {
        return this.languagePack.getAvailableLocales();
    }

    protected String doGetI18String(String key, Locale locale) {
        Map<String, String> stringResources = locale != null && locale.equals(this.languageLocale) ? this.languageResources : (this.languagePack == null ? null : this.languagePack.getResources(locale));
        String resourceString = stringResources == null ? null : stringResources.get(key);
        return resourceString;
    }

    public String getI18NString(String key) {
        return this.getI18NString(key, null, Locale.getDefault());
    }

    public String getI18NString(String key, String[] params) {
        return this.getI18NString(key, params, Locale.getDefault());
    }

    public String getI18NString(String key, Locale locale) {
        return this.getI18NString(key, null, locale);
    }

    private String processI18NString(String resourceString) {
        if (resourceString == null) {
            return null;
        }
        int mnemonicIndex = resourceString.indexOf(38);
        if (mnemonicIndex == 0 || mnemonicIndex > 0 && resourceString.charAt(mnemonicIndex - 1) != '\\') {
            String firstPart = resourceString.substring(0, mnemonicIndex);
            String secondPart = resourceString.substring(mnemonicIndex + 1);
            resourceString = firstPart.concat(secondPart);
        }
        if (resourceString.indexOf(92) > -1) {
            resourceString = resourceString.replaceAll("\\\\", "");
        }
        if (resourceString.indexOf("''") > -1) {
            resourceString = resourceString.replaceAll("''", "'");
        }
        return resourceString;
    }

    public String getI18NString(String key, String[] params, Locale locale) {
        String resourceString = this.doGetI18String(key, locale);
        if (resourceString == null) {
            logger.warn((Object)("Missing resource for key: " + key));
            return '!' + key + '!';
        }
        if (params != null) {
            resourceString = MessageFormat.format(resourceString, params);
        }
        return this.processI18NString(resourceString);
    }

    public char getI18nMnemonic(String key) {
        return this.getI18nMnemonic(key, Locale.getDefault());
    }

    public char getI18nMnemonic(String key, Locale locale) {
        String resourceString = this.doGetI18String(key, locale);
        if (resourceString == null) {
            logger.warn((Object)("Missing resource for key: " + key));
            return '\u0000';
        }
        int mnemonicIndex = resourceString.indexOf(38);
        if (mnemonicIndex > -1 && mnemonicIndex < resourceString.length() - 1) {
            return resourceString.charAt(mnemonicIndex + 1);
        }
        return '\u0000';
    }

    public String getSettingsString(String key) {
        return this.settingsResources == null ? null : this.settingsResources.get(key);
    }

    public int getSettingsInt(String key) {
        String resourceString = this.getSettingsString(key);
        if (resourceString == null) {
            logger.warn((Object)("Missing resource for key: " + key));
            return 0;
        }
        return Integer.parseInt(resourceString);
    }

    public URL getSettingsURL(String urlKey) {
        String path = this.getSettingsString(urlKey);
        if (path == null || path.length() == 0) {
            logger.warn((Object)("Missing resource for key: " + urlKey));
            return null;
        }
        return this.settingsPack.getClass().getClassLoader().getResource(path);
    }

    public InputStream getSettingsInputStream(String streamKey) {
        return this.getSettingsInputStream(streamKey, this.settingsPack.getClass());
    }

    public InputStream getSettingsInputStream(String streamKey, Class<?> resourceClass) {
        String path = this.getSettingsString(streamKey);
        if (path == null || path.length() == 0) {
            logger.warn((Object)("Missing resource for key: " + streamKey));
            return null;
        }
        return resourceClass.getClassLoader().getResourceAsStream(path);
    }

    public String getImagePath(String key) {
        return this.imageResources == null ? null : this.imageResources.get(key);
    }

    public byte[] getImageInBytes(String imageID) {
        InputStream in = this.getImageInputStream(imageID);
        if (in == null) {
            return null;
        }
        byte[] image = null;
        try {
            image = new byte[in.available()];
            in.read(image);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load image:" + imageID), (Throwable)e);
        }
        return image;
    }

    public ImageIcon getImage(String imageID) {
        URL imageURL = this.getImageURL(imageID);
        return imageURL == null ? null : new ImageIcon(imageURL);
    }

    public String getSoundPath(String soundKey) {
        return this.soundResources.get(soundKey);
    }

    protected Map<String, String> getColorResources() {
        return this.colorResources;
    }

    protected SkinPack getSkinPack() {
        return this.skinPack;
    }

    protected ImagePack getImagePack() {
        return this.imagePack;
    }

    protected ResourcePack getSoundPack() {
        return this.soundPack;
    }
}

