/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out;

import java.nio.ByteBuffer;
import net.sf.jqql.Util;
import net.sf.jqql.beans.FriendRemark;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicOutPacket;

public class FriendDataOpPacket
extends _08BasicOutPacket {
    private byte subCommand;
    private int qq;
    private FriendRemark remark;
    private int page;

    public FriendDataOpPacket(QQUser qQUser) {
        super('>', true, qQUser);
        this.subCommand = 1;
        this.remark = new FriendRemark();
        this.page = 0;
    }

    public FriendDataOpPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        switch (this.subCommand) {
            case 0: {
                return "Friend Data _08Packet - Batch Download Remark";
            }
            case 1: {
                return "Friend Data _08Packet - Upload Remark";
            }
            case 3: {
                return "Friend Data _08Packet - Download Remark";
            }
            case 2: {
                return "Friend Data _08Packet - Remove Friend From List";
            }
        }
        return "Friend Data _08Packet - Unknown Sub Command";
    }

    protected void putBody(ByteBuffer byteBuffer) {
        byteBuffer.put(this.subCommand);
        if (this.subCommand == 1 || this.subCommand == 0) {
            byteBuffer.put((byte)this.page);
        }
        if (this.subCommand != 0) {
            byteBuffer.putInt(this.qq);
        }
        if (this.subCommand == 1) {
            byte[] byArray;
            byteBuffer.put((byte)0);
            if (this.remark.name == null || this.remark.name.equals("")) {
                byteBuffer.put((byte)0);
            } else {
                byArray = Util.getBytes(this.remark.name);
                byteBuffer.put((byte)byArray.length);
                byteBuffer.put(byArray);
            }
            if (this.remark.mobile == null || this.remark.mobile.equals("")) {
                byteBuffer.put((byte)0);
            } else {
                byArray = Util.getBytes(this.remark.mobile);
                byteBuffer.put((byte)byArray.length);
                byteBuffer.put(byArray);
            }
            if (this.remark.telephone == null || this.remark.telephone.equals("")) {
                byteBuffer.put((byte)0);
            } else {
                byArray = Util.getBytes(this.remark.telephone);
                byteBuffer.put((byte)byArray.length);
                byteBuffer.put(byArray);
            }
            if (this.remark.address == null || this.remark.address.equals("")) {
                byteBuffer.put((byte)0);
            } else {
                byArray = Util.getBytes(this.remark.address);
                byteBuffer.put((byte)byArray.length);
                byteBuffer.put(byArray);
            }
            if (this.remark.email == null || this.remark.email.equals("")) {
                byteBuffer.put((byte)0);
            } else {
                byArray = Util.getBytes(this.remark.email);
                byteBuffer.put((byte)byArray.length);
                byteBuffer.put(byArray);
            }
            if (this.remark.zipcode == null || this.remark.zipcode.equals("")) {
                byteBuffer.put((byte)0);
            } else {
                byArray = Util.getBytes(this.remark.zipcode);
                byteBuffer.put((byte)byArray.length);
                byteBuffer.put(byArray);
            }
            if (this.remark.note == null || this.remark.note.equals("")) {
                byteBuffer.put((byte)0);
            } else {
                byArray = Util.getBytes(this.remark.note);
                byteBuffer.put((byte)byArray.length);
                byteBuffer.put(byArray);
            }
        }
    }

    protected void parseBody(ByteBuffer byteBuffer) throws PacketParseException {
        this.subCommand = byteBuffer.get();
    }

    public String getAddress() {
        return this.remark.address;
    }

    public void setAddress(String string) {
        this.remark.address = string;
    }

    public String getEmail() {
        return this.remark.email;
    }

    public void setEmail(String string) {
        this.remark.email = string;
    }

    public String getMobile() {
        return this.remark.mobile;
    }

    public void setMobile(String string) {
        this.remark.mobile = string;
    }

    public String getName() {
        return this.remark.name;
    }

    public void setName(String string) {
        this.remark.name = string;
    }

    public String getNote() {
        return this.remark.note;
    }

    public void setNote(String string) {
        this.remark.note = string;
    }

    public String getTelephone() {
        return this.remark.telephone;
    }

    public void setTelephone(String string) {
        this.remark.telephone = string;
    }

    public String getZipcode() {
        return this.remark.zipcode;
    }

    public void setZipcode(String string) {
        this.remark.zipcode = string;
    }

    public int getQQ() {
        return this.qq;
    }

    public void setQQ(int n) {
        this.qq = n;
    }

    public FriendRemark getRemark() {
        return this.remark;
    }

    public void setRemark(FriendRemark friendRemark) {
        this.remark = friendRemark;
    }

    public byte getSubCommand() {
        return this.subCommand;
    }

    public void setSubCommand(byte by) {
        this.subCommand = by;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }
}

