/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionImpl;
import com.hazelcast.nio.serialization.ClassDefinitionWriter;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.serialization.SerializationServiceImpl;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

final class SerializationContextImpl
implements SerializationContext {
    final int version;
    final ConcurrentHashMap<Integer, PortableContext> portableContextMap = new ConcurrentHashMap();
    final SerializationServiceImpl serializationService;
    final ConstructorFunction<Integer, PortableContext> constructorFunction = new ConstructorFunction<Integer, PortableContext>(){

        @Override
        public PortableContext createNew(Integer arg) {
            return new PortableContext();
        }
    };

    SerializationContextImpl(SerializationServiceImpl serializationService, Collection<Integer> portableFactories, int version) {
        this.serializationService = serializationService;
        this.version = version;
        for (int factoryId : portableFactories) {
            this.portableContextMap.put(factoryId, new PortableContext());
        }
    }

    @Override
    public ClassDefinition lookup(int factoryId, int classId) {
        return this.getPortableContext(factoryId).lookup(classId, this.version);
    }

    @Override
    public ClassDefinition lookup(int factoryId, int classId, int version) {
        return this.getPortableContext(factoryId).lookup(classId, version);
    }

    @Override
    public ClassDefinition createClassDefinition(int factoryId, byte[] compressedBinary) throws IOException {
        return this.getPortableContext(factoryId).createClassDefinition(compressedBinary);
    }

    @Override
    public ClassDefinition registerClassDefinition(ClassDefinition cd) {
        return this.getPortableContext(cd.getFactoryId()).registerClassDefinition(cd);
    }

    @Override
    public ClassDefinition lookupOrRegisterClassDefinition(Portable p) throws IOException {
        ClassDefinition cd = this.lookup(p.getFactoryId(), p.getClassId());
        if (cd == null) {
            ClassDefinitionWriter classDefinitionWriter = new ClassDefinitionWriter(this, p.getFactoryId(), p.getClassId());
            p.writePortable(classDefinitionWriter);
            cd = classDefinitionWriter.registerAndGet();
        }
        return cd;
    }

    private void registerNestedDefinitions(ClassDefinitionImpl cd) {
        Set<ClassDefinition> nestedDefinitions = cd.getNestedClassDefinitions();
        for (ClassDefinition classDefinition : nestedDefinitions) {
            ClassDefinitionImpl nestedCD = (ClassDefinitionImpl)classDefinition;
            this.registerClassDefinition(nestedCD);
            this.registerNestedDefinitions(nestedCD);
        }
    }

    private PortableContext getPortableContext(int factoryId) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.portableContextMap, factoryId, this.constructorFunction);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public ManagedContext getManagedContext() {
        return this.serializationService.getManagedContext();
    }

    static void compress(byte[] input, DataOutput out) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setLevel(-1);
        deflater.setStrategy(1);
        deflater.setInput(input);
        deflater.finish();
        byte[] buf = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buf);
            out.write(buf, 0, count);
        }
        deflater.end();
    }

    static void decompress(byte[] compressedData, DataOutput out) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(compressedData);
        byte[] buf = new byte[1024];
        while (!inflater.finished()) {
            try {
                int count = inflater.inflate(buf);
                out.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
        }
        inflater.end();
    }

    static long combineToLong(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFL;
    }

    static int extractInt(long value, boolean lowerBits) {
        return lowerBits ? (int)value : (int)(value >> 32);
    }

    private class PortableContext {
        final ConcurrentMap<Long, ClassDefinitionImpl> versionedDefinitions = new ConcurrentHashMap<Long, ClassDefinitionImpl>();

        private PortableContext() {
        }

        ClassDefinition lookup(int classId, int version) {
            return (ClassDefinition)this.versionedDefinitions.get(SerializationContextImpl.combineToLong(classId, version));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClassDefinition createClassDefinition(byte[] compressedBinary) throws IOException {
            byte[] binary;
            if (compressedBinary == null || compressedBinary.length == 0) {
                throw new IOException("Illegal class-definition binary! ");
            }
            BufferObjectDataOutput out = SerializationContextImpl.this.serializationService.pop();
            try {
                SerializationContextImpl.decompress(compressedBinary, out);
                binary = out.toByteArray();
            }
            finally {
                SerializationContextImpl.this.serializationService.push(out);
            }
            ClassDefinitionImpl cd = new ClassDefinitionImpl();
            cd.readData(SerializationContextImpl.this.serializationService.createObjectDataInput(binary));
            cd.setBinary(compressedBinary);
            SerializationContextImpl.this.registerNestedDefinitions(cd);
            ClassDefinitionImpl currentCd = this.versionedDefinitions.putIfAbsent(SerializationContextImpl.combineToLong(cd.classId, SerializationContextImpl.this.getVersion()), cd);
            return currentCd == null ? cd : currentCd;
        }

        ClassDefinition registerClassDefinition(ClassDefinition cd) {
            if (cd == null) {
                return null;
            }
            ClassDefinitionImpl cdImpl = (ClassDefinitionImpl)cd;
            if (cdImpl.getVersion() < 0) {
                cdImpl.version = SerializationContextImpl.this.getVersion();
            }
            if (cdImpl.getBinary() == null) {
                BufferObjectDataOutput out = SerializationContextImpl.this.serializationService.pop();
                try {
                    cdImpl.writeData(out);
                    byte[] binary = out.toByteArray();
                    out.clear();
                    SerializationContextImpl.compress(binary, out);
                    cdImpl.setBinary(out.toByteArray());
                }
                catch (IOException e) {
                    throw new HazelcastSerializationException(e);
                }
                finally {
                    SerializationContextImpl.this.serializationService.push(out);
                }
            }
            long versionedClassId = SerializationContextImpl.combineToLong(cdImpl.getClassId(), cdImpl.getVersion());
            SerializationContextImpl.this.registerNestedDefinitions(cdImpl);
            ClassDefinitionImpl currentCd = this.versionedDefinitions.putIfAbsent(versionedClassId, cdImpl);
            return currentCd == null ? cdImpl : currentCd;
        }
    }
}

