/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.CipherHelper;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketWriter;
import com.hazelcast.nio.TcpIpConnection;
import com.hazelcast.util.ExceptionUtil;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;

class SocketPacketWriter
implements SocketWriter<Packet> {
    private final PacketWriter packetWriter;
    final TcpIpConnection connection;
    final IOService ioService;
    final ILogger logger;

    SocketPacketWriter(TcpIpConnection connection) {
        this.connection = connection;
        this.ioService = connection.getConnectionManager().ioService;
        this.logger = this.ioService.getLogger(SocketPacketWriter.class.getName());
        boolean symmetricEncryptionEnabled = CipherHelper.isSymmetricEncryptionEnabled(this.ioService);
        if (symmetricEncryptionEnabled) {
            this.packetWriter = new SymmetricCipherPacketWriter();
            this.logger.info("Writer started with SymmetricEncryption");
        } else {
            this.packetWriter = new DefaultPacketWriter();
        }
    }

    @Override
    public boolean write(Packet socketWritable, ByteBuffer socketBuffer) throws Exception {
        return this.packetWriter.writePacket(socketWritable, socketBuffer);
    }

    private class SymmetricCipherPacketWriter
    implements PacketWriter {
        final Cipher cipher;
        ByteBuffer packetBuffer;
        boolean packetWritten;

        SymmetricCipherPacketWriter() {
            this.packetBuffer = ByteBuffer.allocate(SocketPacketWriter.this.ioService.getSocketSendBufferSize() * 1024);
            this.packetWritten = false;
            this.cipher = this.init();
        }

        private Cipher init() {
            Cipher c;
            try {
                c = CipherHelper.createSymmetricWriterCipher(SocketPacketWriter.this.ioService.getSymmetricEncryptionConfig());
            }
            catch (Exception e) {
                SocketPacketWriter.this.logger.severe("Symmetric Cipher for WriteHandler cannot be initialized.", e);
                CipherHelper.handleCipherException(e, SocketPacketWriter.this.connection);
                throw ExceptionUtil.rethrow(e);
            }
            return c;
        }

        @Override
        public boolean writePacket(Packet packet, ByteBuffer socketBuffer) throws Exception {
            if (!this.packetWritten) {
                if (socketBuffer.remaining() < 4) {
                    return false;
                }
                int size = this.cipher.getOutputSize(packet.size());
                socketBuffer.putInt(size);
                if (this.packetBuffer.capacity() < packet.size()) {
                    this.packetBuffer = ByteBuffer.allocate(packet.size());
                }
                if (!packet.writeTo(this.packetBuffer)) {
                    throw new HazelcastException("Packet didn't fit into the buffer!");
                }
                this.packetBuffer.flip();
                this.packetWritten = true;
            }
            if (socketBuffer.hasRemaining()) {
                int outputSize = this.cipher.getOutputSize(this.packetBuffer.remaining());
                if (outputSize <= socketBuffer.remaining()) {
                    this.cipher.update(this.packetBuffer, socketBuffer);
                } else {
                    int min = Math.min(this.packetBuffer.remaining(), socketBuffer.remaining());
                    int len = min / 2;
                    if (len > 0) {
                        int limitOld = this.packetBuffer.limit();
                        this.packetBuffer.limit(this.packetBuffer.position() + len);
                        this.cipher.update(this.packetBuffer, socketBuffer);
                        this.packetBuffer.limit(limitOld);
                    }
                }
                if (!this.packetBuffer.hasRemaining() && socketBuffer.remaining() >= this.cipher.getOutputSize(0)) {
                    socketBuffer.put(this.cipher.doFinal());
                    this.packetWritten = false;
                    this.packetBuffer.clear();
                    return true;
                }
            }
            return false;
        }
    }

    private class DefaultPacketWriter
    implements PacketWriter {
        private DefaultPacketWriter() {
        }

        @Override
        public boolean writePacket(Packet packet, ByteBuffer socketBB) {
            return packet.writeTo(socketBB);
        }
    }

    private static interface PacketWriter {
        public boolean writePacket(Packet var1, ByteBuffer var2) throws Exception;
    }
}

