/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.map.record.OffHeapRecord;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordFactory;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.storage.DataRef;
import com.hazelcast.storage.Storage;

public class OffHeapRecordFactory
implements RecordFactory<Data> {
    private final Storage<DataRef> storage;
    private final SerializationService serializationService;
    private final PartitioningStrategy partitionStrategy;
    private final boolean statisticsEnabled;

    public OffHeapRecordFactory(MapConfig config, Storage<DataRef> storage, SerializationService serializationService, PartitioningStrategy partitionStrategy) {
        this.storage = storage;
        this.serializationService = serializationService;
        this.partitionStrategy = partitionStrategy;
        this.statisticsEnabled = config.isStatisticsEnabled();
    }

    @Override
    public InMemoryFormat getStorageFormat() {
        return InMemoryFormat.OFFHEAP;
    }

    @Override
    public Record<Data> newRecord(Data key, Object value) {
        Data v = this.serializationService.toData(value, this.partitionStrategy);
        return new OffHeapRecord(this.storage, key, v, this.statisticsEnabled);
    }

    @Override
    public void setValue(Record<Data> record, Object value) {
        Data v = value instanceof Data ? (Data)value : this.serializationService.toData(value, this.partitionStrategy);
        record.setValue(v);
    }

    @Override
    public boolean equals(Object value1, Object value2) {
        return this.serializationService.toData(value1).equals(this.serializationService.toData(value2));
    }
}

