/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.DirInfo;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class DirInfoCmd
extends LocCommand {
    public static final int CODE_SUCCESS = 1;
    public static final int CODE_ERROR = 2;
    private final int code;
    private final DirInfo dirInfo;

    protected DirInfoCmd(SnacPacket snacPacket) {
        super(12);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.code = BinaryTools.getUShort(byteBlock, 0);
        int n = BinaryTools.getUShort(byteBlock, 2);
        ByteBlock byteBlock2 = byteBlock.subBlock(4);
        this.dirInfo = DirInfo.readDirInfo(byteBlock2, n);
    }

    public DirInfoCmd(DirInfo dirInfo) {
        this(dirInfo != null ? 1 : 2, dirInfo);
    }

    public DirInfoCmd(int n, DirInfo dirInfo) {
        super(12);
        DefensiveTools.checkRange(n, "code", 0);
        this.code = n;
        this.dirInfo = dirInfo;
    }

    public final int getResultCode() {
        return this.code;
    }

    public final DirInfo getDirInfo() {
        return this.dirInfo;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.code);
        if (this.dirInfo != null) {
            this.dirInfo.write(outputStream);
        }
    }

    public String toString() {
        return "DirInfoCmd: code=" + this.code + ", dirinfo=<" + this.dirInfo + ">";
    }
}

