/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ExtraInfoBlock;

public class ExtraInfoBlockHolder
implements Writable {
    public static final int CODE_DEFAULT = 7;
    private final ExtraInfoBlock first;
    private final int code;
    private final ExtraInfoBlock second;
    private final int totalSize;

    public static final ExtraInfoBlockHolder readBlockHolder(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        int n = byteBlock.getOffset();
        ExtraInfoBlock extraInfoBlock = ExtraInfoBlock.readExtraInfoBlock(byteBlock);
        if (extraInfoBlock == null) {
            return null;
        }
        if ((byteBlock = byteBlock.subBlock(extraInfoBlock.getTotalSize())).getLength() < 1) {
            return null;
        }
        short s = BinaryTools.getUByte(byteBlock, 0);
        ExtraInfoBlock extraInfoBlock2 = ExtraInfoBlock.readExtraInfoBlock(byteBlock = byteBlock.subBlock(1));
        if (extraInfoBlock2 == null) {
            return null;
        }
        int n2 = byteBlock.getOffset() + extraInfoBlock2.getTotalSize() - n;
        return new ExtraInfoBlockHolder(extraInfoBlock, s, extraInfoBlock2, n2);
    }

    public static final ExtraInfoBlockHolder[] readBlockHolders(ByteBlock byteBlock) {
        ExtraInfoBlockHolder extraInfoBlockHolder;
        LinkedList<ExtraInfoBlockHolder> linkedList = new LinkedList<ExtraInfoBlockHolder>();
        while ((extraInfoBlockHolder = ExtraInfoBlockHolder.readBlockHolder(byteBlock)) != null) {
            linkedList.add(extraInfoBlockHolder);
            byteBlock = byteBlock.subBlock(extraInfoBlockHolder.getTotalSize());
        }
        return linkedList.toArray(new ExtraInfoBlockHolder[0]);
    }

    protected ExtraInfoBlockHolder(ExtraInfoBlock extraInfoBlock, int n, ExtraInfoBlock extraInfoBlock2, int n2) {
        DefensiveTools.checkRange(n, "code", -1);
        DefensiveTools.checkRange(n2, "totalSize", -1);
        this.first = extraInfoBlock;
        this.code = n;
        this.second = extraInfoBlock2;
        this.totalSize = n2;
    }

    public ExtraInfoBlockHolder(ExtraInfoBlock extraInfoBlock) {
        this(extraInfoBlock, 7, extraInfoBlock);
    }

    public ExtraInfoBlockHolder(ExtraInfoBlock extraInfoBlock, int n, ExtraInfoBlock extraInfoBlock2) {
        this(extraInfoBlock, n, extraInfoBlock2, -1);
    }

    public final ExtraInfoBlock getFirstBlock() {
        return this.first;
    }

    public final int getCode() {
        return this.code;
    }

    public final ExtraInfoBlock getSecondBlock() {
        return this.second;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        return (this.first == null ? 0L : this.first.getWritableLength()) + 1L + (this.second == null ? 0L : this.second.getWritableLength());
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.first != null) {
            this.first.write(outputStream);
        }
        BinaryTools.writeUByte(outputStream, this.code);
        if (this.second != null) {
            this.second.write(outputStream);
        }
    }

    public String toString() {
        return "ExtraInfoBlockHolder: code=" + this.code + ", first=" + this.first + ", second=" + this.second;
    }
}

