/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;

public class RvProxyInitSendCmd
extends RvProxyCmd {
    private final String sn;
    private final long icbmMessageId;

    protected RvProxyInitSendCmd(RvProxyPacket rvProxyPacket) {
        super(rvProxyPacket);
        ByteBlock byteBlock = rvProxyPacket.getCommandData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        if (stringBlock != null) {
            this.sn = stringBlock.getString();
            ByteBlock byteBlock2 = byteBlock.subBlock(stringBlock.getTotalSize());
            this.icbmMessageId = BinaryTools.getLong(byteBlock2, 0);
        } else {
            this.sn = null;
            this.icbmMessageId = 0L;
        }
    }

    public RvProxyInitSendCmd(String string, long l) {
        super(2);
        DefensiveTools.checkNull(string, "sn");
        this.sn = string;
        this.icbmMessageId = l;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final long getIcbmMessageId() {
        return this.icbmMessageId;
    }

    public void writeCommandData(OutputStream outputStream) throws IOException {
        if (this.sn != null) {
            OscarTools.writeScreenname(outputStream, this.sn);
            BinaryTools.writeLong(outputStream, this.icbmMessageId);
        }
    }

    public String toString() {
        return "RvProxyInitSendCmd: sn=" + this.sn + ", icbmMessageId=" + this.icbmMessageId;
    }
}

