/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;

public class RvProxyInitRecvCmd
extends RvProxyCmd {
    private final String sn;
    private final long icbmMessageId;
    private final int port;

    protected RvProxyInitRecvCmd(RvProxyPacket rvProxyPacket) {
        super(rvProxyPacket);
        ByteBlock byteBlock = rvProxyPacket.getCommandData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        if (stringBlock != null) {
            this.sn = stringBlock.getString();
            ByteBlock byteBlock2 = byteBlock.subBlock(stringBlock.getTotalSize());
            this.port = BinaryTools.getUShort(byteBlock2, 0);
            this.icbmMessageId = BinaryTools.getLong(byteBlock2, 2);
        } else {
            this.sn = null;
            this.icbmMessageId = 0L;
            this.port = -1;
        }
    }

    public RvProxyInitRecvCmd(String string, long l, int n) {
        super(4);
        DefensiveTools.checkNull(string, "sn");
        DefensiveTools.checkRange(n, "port", -1);
        this.sn = string;
        this.icbmMessageId = l;
        this.port = n;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final long getIcbmMessageId() {
        return this.icbmMessageId;
    }

    public final int getPort() {
        return this.port;
    }

    public void writeCommandData(OutputStream outputStream) throws IOException {
        if (this.sn != null) {
            OscarTools.writeScreenname(outputStream, this.sn);
            if (this.port != -1) {
                BinaryTools.writeUShort(outputStream, this.port);
                BinaryTools.writeLong(outputStream, this.icbmMessageId);
            }
        }
    }

    public String toString() {
        return "RvProxyInitRecvCmd: sn=" + this.sn + ", icbmMessageId=" + this.icbmMessageId + ", port=" + this.port;
    }
}

