/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.Dumpable;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ItemContents;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.util.Utilities;
import java.io.PrintWriter;

public class Relation
implements Dumpable {
    private String name;
    private Utterance owner;
    private Item head;
    private Item tail;
    public static final String TOKEN = "Token";
    public static final String WORD = "Word";
    public static final String PHRASE = "Phrase";
    public static final String SEGMENT = "Segment";
    public static final String SYLLABLE = "Syllable";
    public static final String SYLLABLE_STRUCTURE = "SylStructure";
    public static final String TARGET = "Target";
    public static final String UNIT = "Unit";

    Relation(String name, Utterance owner) {
        this.name = name;
        this.owner = owner;
        this.head = null;
        this.tail = null;
    }

    public String getName() {
        return this.name;
    }

    public Item getHead() {
        return this.head;
    }

    void setHead(Item item) {
        this.head = item;
    }

    public Item getTail() {
        return this.tail;
    }

    void setTail(Item item) {
        this.tail = item;
    }

    public Item appendItem() {
        return this.appendItem(null);
    }

    public Item appendItem(Item originalItem) {
        ItemContents contents = originalItem == null ? null : originalItem.getSharedContents();
        Item newItem = new Item(this, contents);
        if (this.head == null) {
            this.head = newItem;
        }
        if (this.tail != null) {
            this.tail.attach(newItem);
        }
        this.tail = newItem;
        return newItem;
    }

    public Utterance getUtterance() {
        return this.owner;
    }

    @Override
    public void dump(PrintWriter pw, int pad, String title) {
        Utilities.dump(pw, pad, "========= Relation: " + title + " =========");
        for (Item item = this.head; item != null; item = item.getNext()) {
            item.dump(pw, pad + 4, title);
        }
    }
}

