/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.control.PacketQueueControl;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.RTPSourceStream;

class JitterBufferStats
implements PacketQueueControl {
    private int discardedFull;
    private int discardedLate;
    private int discardedReset;
    private int discardedShrink;
    private int discardedVeryLate;
    private int maxSizeReached;
    private int nbAdd;
    private int nbGrow;
    private int nbReset;
    private int sizePerPacket;
    private final RTPSourceStream stream;

    JitterBufferStats(RTPSourceStream stream) {
        this.stream = stream;
    }

    public Component getControlComponent() {
        return null;
    }

    public int getCurrentDelayMs() {
        return this.getCurrentDelayPackets() * 20;
    }

    public int getCurrentDelayPackets() {
        return this.getCurrentSizePackets() / 2;
    }

    public int getCurrentPacketCount() {
        return this.stream.q.getFillCount();
    }

    public int getCurrentSizePackets() {
        return this.stream.q.getCapacity();
    }

    public int getDiscarded() {
        return this.getDiscardedFull() + this.getDiscardedLate() + this.getDiscardedReset() + this.getDiscardedShrink() + this.getDiscardedVeryLate();
    }

    public int getDiscardedFull() {
        return this.discardedFull;
    }

    public int getDiscardedLate() {
        return this.discardedLate;
    }

    public int getDiscardedReset() {
        return this.discardedReset;
    }

    public int getDiscardedShrink() {
        return this.discardedShrink;
    }

    public int getDiscardedVeryLate() {
        return this.discardedVeryLate;
    }

    public int getMaxSizeReached() {
        return this.maxSizeReached;
    }

    int getNbAdd() {
        return this.nbAdd;
    }

    int getSizePerPacket() {
        return this.sizePerPacket;
    }

    void incrementDiscardedFull() {
        ++this.discardedFull;
    }

    void incrementDiscardedLate() {
        ++this.discardedLate;
    }

    void incrementDiscardedReset() {
        ++this.discardedReset;
    }

    void incrementDiscardedShrink() {
        ++this.discardedShrink;
    }

    void incrementDiscardedVeryLate() {
        ++this.discardedVeryLate;
    }

    void incrementNbAdd() {
        ++this.nbAdd;
    }

    void incrementNbGrow() {
        ++this.nbGrow;
    }

    void incrementNbReset() {
        ++this.nbReset;
    }

    public boolean isAdaptiveBufferEnabled() {
        return this.stream.getBehaviour().isAdaptive();
    }

    void printStats() {
        String cn = RTPSourceStream.class.getName() + " ";
        Log.info(cn + "Total packets added: " + this.getNbAdd());
        Log.info(cn + "Times reset() called: " + this.nbReset);
        Log.info(cn + "Times grow() called: " + this.nbGrow);
        Log.info(cn + "Packets dropped because full: " + this.getDiscardedFull());
        Log.info(cn + "Packets dropped while shrinking: " + this.getDiscardedShrink());
        Log.info(cn + "Packets dropped because they were late: " + this.getDiscardedLate());
        Log.info(cn + "Packets dropped because they were late by more than MAX_SIZE: " + this.getDiscardedVeryLate());
        Log.info(cn + "Packets dropped in reset(): " + this.getDiscardedReset());
        Log.info(cn + "Max size reached: " + this.getMaxSizeReached());
        Log.info(cn + "Adaptive jitter buffer mode was " + (this.isAdaptiveBufferEnabled() ? "enabled" : "disabled"));
    }

    void updateMaxSizeReached() {
        int size = this.getCurrentSizePackets();
        if (this.maxSizeReached < size) {
            this.maxSizeReached = size;
        }
    }

    void updateSizePerPacket(Buffer buffer) {
        int bufferLength = buffer.getLength();
        this.sizePerPacket = this.sizePerPacket == 0 ? bufferLength : (this.sizePerPacket + bufferLength) / 2;
    }
}

