/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.PortTracker;
import net.java.sip.communicator.util.ServiceUtils;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.AwsCandidateHarvester;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.TransportManager;
import org.jivesoftware.smack.packet.PacketExtension;
import org.osgi.framework.BundleContext;

public class IceUdpTransportManager
extends TransportManager {
    private static final Logger logger = Logger.getLogger(IceUdpTransportManager.class);
    private static final int[] COMPONENT_IDS = new int[]{1, 2};
    private static boolean initializePortNumbers = true;
    private static final String DISABLE_AWS_HARVESTER = "org.jitsi.videobridge.DISABLE_AWS_HARVESTER";
    private static final String FORCE_AWS_HARVESTER = "org.jitsi.videobridge.FORCE_AWS_HARVESTER";
    private static final String NAT_HARVESTER_LOCAL_ADDRESS = "org.jitsi.videobridge.NAT_HARVESTER_LOCAL_ADDRESS";
    private static final String NAT_HARVESTER_PUBLIC_ADDRESS = "org.jitsi.videobridge.NAT_HARVESTER_PUBLIC_ADDRESS";
    private final Agent iceAgent;
    private final PropertyChangeListener iceAgentStateChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            IceUdpTransportManager.this.iceAgentStateChange(ev);
        }
    };
    private final IceMediaStream iceStream;
    private final PropertyChangeListener iceStreamPairChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            IceUdpTransportManager.this.iceStreamPairChange(ev);
        }
    };
    private StreamConnector streamConnector;

    private static void logd(String s) {
        logger.info((Object)s);
    }

    public IceUdpTransportManager(Channel channel) throws IOException {
        super(channel);
        this.iceAgent = this.createIceAgent();
        this.iceAgent.addStateChangeListener(this.iceAgentStateChangeListener);
        this.iceStream = this.iceAgent.getStream(this.getChannel().getContent().getName());
        this.iceStream.addPairChangeListener(this.iceStreamPairChangeListener);
    }

    private boolean canReach(Component component, RemoteCandidate remoteCandidate) {
        for (LocalCandidate localCandidate : component.getLocalCandidates()) {
            if (!localCandidate.canReach((Candidate)remoteCandidate)) continue;
            return true;
        }
        return false;
    }

    protected void channelPropertyChange(PropertyChangeEvent ev) {
        super.channelPropertyChange(ev);
        if ("initiator".equals(ev.getPropertyName()) && this.iceAgent != null) {
            Channel channel = (Channel)((Object)ev.getSource());
            this.iceAgent.setControlling(channel.isInitiator());
        }
    }

    public void close() {
        super.close();
        if (this.iceStream != null) {
            this.iceStream.removePairStateChangeListener(this.iceStreamPairChangeListener);
        }
        if (this.iceAgent != null) {
            this.iceAgent.removeStateChangeListener(this.iceAgentStateChangeListener);
            this.iceAgent.free();
        }
    }

    private synchronized void closeStreamConnector() {
        if (this.streamConnector != null) {
            this.streamConnector.close();
            this.streamConnector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Agent createIceAgent() throws IOException {
        Channel channel = this.getChannel();
        Content content = channel.getContent();
        NetworkAddressManagerService nams = (NetworkAddressManagerService)ServiceUtils.getService((BundleContext)this.getBundleContext(), NetworkAddressManagerService.class);
        Agent iceAgent = nams.createIceAgent();
        this.appendVideobridgeHarvesters(iceAgent);
        iceAgent.setControlling(channel.isInitiator());
        iceAgent.setPerformConsentFreshness(true);
        Class<IceUdpTransportManager> clazz = IceUdpTransportManager.class;
        synchronized (IceUdpTransportManager.class) {
            block7: {
                if (initializePortNumbers) {
                    initializePortNumbers = false;
                    JitsiTransportManager.initializePortNumbers();
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                PortTracker portTracker = JitsiTransportManager.getPortTracker(content.getMediaType());
                IceMediaStream iceStream = nams.createIceStream(portTracker.getPort(), content.getName(), iceAgent);
                try {
                    portTracker.setNextPort(1 + ((LocalCandidate)iceStream.getComponent(2).getLocalCandidates().get(0)).getTransportAddress().getPort());
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block7;
                    throw (ThreadDeath)t;
                }
            }
            return iceAgent;
        }
    }

    private void appendVideobridgeHarvesters(Agent iceAgent) {
        TransportAddress publicAddress;
        TransportAddress localAddress;
        ConfigurationService cfg;
        AwsCandidateHarvester awsHarvester = null;
        if (AwsCandidateHarvester.smellsLikeAnEC2()) {
            awsHarvester = new AwsCandidateHarvester();
        }
        if ((cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)this.getBundleContext(), ConfigurationService.class)) == null) {
            logger.info((Object)"No configuration found. Will continue without custom candidate harvesters");
            return;
        }
        if (awsHarvester == null && cfg.getBoolean(FORCE_AWS_HARVESTER, false)) {
            logger.info((Object)"Forcing use of AWS candidate harvesting.");
            awsHarvester = new AwsCandidateHarvester();
        }
        if (awsHarvester != null && !cfg.getBoolean(DISABLE_AWS_HARVESTER, false)) {
            logger.info((Object)"Appending an AWS harvester to the ICE agent.");
            iceAgent.addCandidateHarvester((CandidateHarvester)awsHarvester);
        }
        String localAddressStr = cfg.getString(NAT_HARVESTER_LOCAL_ADDRESS);
        String publicAddressStr = cfg.getString(NAT_HARVESTER_PUBLIC_ADDRESS);
        if (localAddressStr == null || publicAddressStr == null) {
            return;
        }
        try {
            localAddress = new TransportAddress(localAddressStr, 9, Transport.UDP);
            publicAddress = new TransportAddress(publicAddressStr, 9, Transport.UDP);
            logger.info((Object)("Will append a NAT harvester for " + localAddress + "=>" + publicAddress));
        }
        catch (Exception exc) {
            logger.info((Object)("Failed to create a NAT harvester for local address=" + localAddressStr + " and public address=" + publicAddressStr));
            return;
        }
        MappingCandidateHarvester natHarvester = new MappingCandidateHarvester(publicAddress, localAddress);
        iceAgent.addCandidateHarvester((CandidateHarvester)natHarvester);
    }

    public BundleContext getBundleContext() {
        return this.getChannel().getBundleContext();
    }

    private StreamConnector createStreamConnector() {
        DatagramSocket[] streamConnectorSockets = this.getStreamConnectorSockets();
        return streamConnectorSockets == null ? null : new DefaultStreamConnector(streamConnectorSockets[0], streamConnectorSockets[1]);
    }

    protected void describe(IceUdpTransportPacketExtension pe) {
        pe.setPassword(this.iceAgent.getLocalPassword());
        pe.setUfrag(this.iceAgent.getLocalUfrag());
        IceMediaStream stream = this.iceAgent.getStream(this.getChannel().getContent().getName());
        if (stream != null) {
            for (Component component : stream.getComponents()) {
                List candidates = component.getLocalCandidates();
                if (candidates == null || candidates.isEmpty()) continue;
                for (LocalCandidate candidate : candidates) {
                    this.describe(candidate, pe);
                }
            }
        }
    }

    private void describe(LocalCandidate candidate, IceUdpTransportPacketExtension pe) {
        CandidatePacketExtension candidatePE = new CandidatePacketExtension();
        Component component = candidate.getParentComponent();
        candidatePE.setComponent(component.getComponentID());
        candidatePE.setFoundation(candidate.getFoundation());
        candidatePE.setGeneration(component.getParentStream().getParentAgent().getGeneration());
        candidatePE.setID(this.generateCandidateID(candidate));
        candidatePE.setNetwork(0);
        candidatePE.setPriority(candidate.getPriority());
        candidatePE.setProtocol(candidate.getTransport().toString());
        candidatePE.setType(net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidateType.valueOf((String)candidate.getType().toString()));
        TransportAddress transportAddress = candidate.getTransportAddress();
        candidatePE.setIP(transportAddress.getHostAddress());
        candidatePE.setPort(transportAddress.getPort());
        TransportAddress relatedAddress = candidate.getRelatedAddress();
        if (relatedAddress != null) {
            candidatePE.setRelAddr(relatedAddress.getHostAddress());
            candidatePE.setRelPort(relatedAddress.getPort());
        }
        pe.addChildExtension((PacketExtension)candidatePE);
    }

    private String generateCandidateID(LocalCandidate candidate) {
        StringBuilder candidateID = new StringBuilder();
        Channel channel = this.getChannel();
        Content content = channel.getContent();
        Conference conference = content.getConference();
        candidateID.append(conference.getID());
        candidateID.append(Long.toHexString(content.hashCode()));
        candidateID.append(channel.getID());
        Agent iceAgent = candidate.getParentComponent().getParentStream().getParentAgent();
        candidateID.append(Long.toHexString(iceAgent.hashCode()));
        candidateID.append(Long.toHexString(iceAgent.getGeneration()));
        candidateID.append(Long.toHexString(candidate.hashCode()));
        return candidateID.toString();
    }

    public synchronized StreamConnector getStreamConnector() {
        DatagramSocket[] streamConnectorSockets;
        StreamConnector streamConnector = this.streamConnector;
        if (streamConnector != null && (streamConnectorSockets = this.getStreamConnectorSockets()) != null && (streamConnector.getDataSocket() != streamConnectorSockets[0] || streamConnector.getControlSocket() != streamConnectorSockets[1])) {
            this.closeStreamConnector();
        }
        if (this.streamConnector == null) {
            this.streamConnector = this.createStreamConnector();
        }
        return this.streamConnector;
    }

    private DatagramSocket[] getStreamConnectorSockets() {
        IceMediaStream stream = this.iceAgent.getStream(this.getChannel().getContent().getName());
        if (stream != null) {
            DatagramSocket[] streamConnectorSockets = new DatagramSocket[COMPONENT_IDS.length];
            int streamConnectorSocketCount = 0;
            for (int i = 0; i < COMPONENT_IDS.length; ++i) {
                DatagramSocket streamConnectorSocket;
                CandidatePair selectedPair;
                Component component = stream.getComponent(COMPONENT_IDS[i]);
                if (component == null || (selectedPair = component.getSelectedPair()) == null || (streamConnectorSocket = selectedPair.getLocalCandidate().getDatagramSocket()) == null) continue;
                streamConnectorSockets[i] = streamConnectorSocket;
                ++streamConnectorSocketCount;
            }
            if (streamConnectorSocketCount > 0) {
                return streamConnectorSockets;
            }
        }
        return null;
    }

    public MediaStreamTarget getStreamTarget() {
        IceMediaStream stream = this.iceAgent.getStream(this.getChannel().getContent().getName());
        MediaStreamTarget streamTarget = null;
        if (stream != null) {
            InetSocketAddress[] streamTargetAddresses = new InetSocketAddress[COMPONENT_IDS.length];
            int streamTargetAddressCount = 0;
            for (int i = 0; i < COMPONENT_IDS.length; ++i) {
                TransportAddress streamTargetAddress;
                CandidatePair selectedPair;
                Component component = stream.getComponent(COMPONENT_IDS[i]);
                if (component == null || (selectedPair = component.getSelectedPair()) == null || (streamTargetAddress = selectedPair.getRemoteCandidate().getTransportAddress()) == null) continue;
                streamTargetAddresses[i] = streamTargetAddress;
                ++streamTargetAddressCount;
            }
            if (streamTargetAddressCount > 0) {
                streamTarget = new MediaStreamTarget(streamTargetAddresses[0], streamTargetAddresses[1]);
            }
        }
        return streamTarget;
    }

    public String getXmlNamespace() {
        return "urn:xmpp:jingle:transports:ice-udp:1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iceAgentStateChange(PropertyChangeEvent ev) {
        boolean interrupted = false;
        try {
            try {
                Channel channel = this.getChannel();
                Content content = channel.getContent();
                Conference conference = content.getConference();
                IceUdpTransportManager.logd("ICE processing state of " + this.getClass().getSimpleName() + " #" + Integer.toHexString(this.hashCode()) + " of channel " + channel.getID() + " of content " + content.getName() + " of conference " + conference.getID() + " changed from " + ev.getOldValue() + " to " + ev.getNewValue() + ".");
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    interrupted = true;
                } else if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                Object var7_8 = null;
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            Object var7_7 = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    private void iceStreamPairChange(PropertyChangeEvent ev) {
        if ("PairConsentFreshnessChanged".equals(ev.getPropertyName())) {
            this.getChannel().touch();
        }
    }

    public synchronized boolean startConnectivityEstablishment(IceUdpTransportPacketExtension transport) {
        String password;
        boolean iceAgentStateIsRunning = IceProcessingState.RUNNING.equals((Object)this.iceAgent.getState());
        int remoteCandidateCount = 0;
        String media = this.getChannel().getContent().getName();
        IceMediaStream stream2 = this.iceAgent.getStream(media);
        String ufrag = transport.getUfrag();
        if (ufrag != null) {
            stream2.setRemoteUfrag(ufrag);
        }
        if ((password = transport.getPassword()) != null) {
            stream2.setRemotePassword(password);
        }
        List candidates = transport.getChildExtensionsOfType(CandidatePacketExtension.class);
        if (iceAgentStateIsRunning && candidates.size() == 0) {
            return false;
        }
        Collections.sort(candidates);
        int generation = this.iceAgent.getGeneration();
        for (CandidatePacketExtension candidate : candidates) {
            int relPort;
            if (candidate.getGeneration() != generation) continue;
            Component component = stream2.getComponent(candidate.getComponent());
            TransportAddress relatedAddress = null;
            String relAddr = candidate.getRelAddr();
            if (relAddr != null && (relPort = candidate.getRelPort()) != -1) {
                relatedAddress = new TransportAddress(relAddr, relPort, Transport.parse((String)candidate.getProtocol()));
            }
            RemoteCandidate relatedCandidate = component.findRemoteCandidate(relatedAddress);
            RemoteCandidate remoteCandidate = new RemoteCandidate(new TransportAddress(candidate.getIP(), candidate.getPort(), Transport.parse((String)candidate.getProtocol())), component, CandidateType.parse((String)candidate.getType().toString()), candidate.getFoundation(), (long)candidate.getPriority(), relatedCandidate);
            if (!this.canReach(component, remoteCandidate)) continue;
            if (iceAgentStateIsRunning) {
                component.addUpdateRemoteCandidates(remoteCandidate);
            } else {
                component.addRemoteCandidate(remoteCandidate);
            }
            ++remoteCandidateCount;
        }
        if (iceAgentStateIsRunning) {
            if (remoteCandidateCount == 0) {
                return false;
            }
            for (IceMediaStream stream2 : this.iceAgent.getStreams()) {
                for (Component component : stream2.getComponents()) {
                    component.updateRemoteCandidates();
                }
            }
        } else if (remoteCandidateCount != 0) {
            for (IceMediaStream stream2 : this.iceAgent.getStreams()) {
                for (Component component : stream2.getComponents()) {
                    if (component.getRemoteCandidateCount() >= 1) continue;
                    remoteCandidateCount = 0;
                    break;
                }
                if (remoteCandidateCount != 0) continue;
                break;
            }
            if (remoteCandidateCount != 0) {
                this.iceAgent.startConnectivityEstablishment();
            }
        }
        return iceAgentStateIsRunning || remoteCandidateCount != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapupConnectivityEstablishment() throws OperationFailedException {
        final Object syncRoot = new Object();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent ev) {
                Object newValue = ev.getNewValue();
                if (IceProcessingState.COMPLETED.equals(newValue) || IceProcessingState.FAILED.equals(newValue) || IceProcessingState.TERMINATED.equals(newValue)) {
                    Agent iceAgent = (Agent)ev.getSource();
                    iceAgent.removeStateChangeListener((PropertyChangeListener)this);
                    if (iceAgent == IceUdpTransportManager.this.iceAgent) {
                        Object object = syncRoot;
                        synchronized (object) {
                            syncRoot.notify();
                        }
                    }
                }
            }
        };
        this.iceAgent.addStateChangeListener(propertyChangeListener);
        boolean interrupted = false;
        Object object = syncRoot;
        synchronized (object) {
            while (IceProcessingState.RUNNING.equals((Object)this.iceAgent.getState())) {
                try {
                    syncRoot.wait(1000L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.iceAgent.removeStateChangeListener(propertyChangeListener);
        if (IceProcessingState.FAILED.equals((Object)this.iceAgent.getState())) {
            throw new OperationFailedException("Could not establish connection (ICE failed)", 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JitsiTransportManager
    extends net.java.sip.communicator.service.protocol.media.TransportManager<MediaAwareCallPeer<?, ?, ?>> {
        public static PortTracker getPortTracker(MediaType mediaType) {
            return net.java.sip.communicator.service.protocol.media.TransportManager.getPortTracker((MediaType)mediaType);
        }

        public static void initializePortNumbers() {
            net.java.sip.communicator.service.protocol.media.TransportManager.initializePortNumbers();
        }

        private JitsiTransportManager(MediaAwareCallPeer<?, ?, ?> callPeer) {
            super(callPeer);
        }

        public long getHarvestingTime(String arg0) {
            return 0L;
        }

        public String getICECandidateExtendedType(String arg0) {
            return null;
        }

        public InetSocketAddress getICELocalHostAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICELocalReflexiveAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICELocalRelayedAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICERemoteHostAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICERemoteReflexiveAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICERemoteRelayedAddress(String arg0) {
            return null;
        }

        public String getICEState() {
            return null;
        }

        protected InetAddress getIntendedDestination(MediaAwareCallPeer<?, ?, ?> arg0) {
            return null;
        }

        public int getNbHarvesting() {
            return 0;
        }

        public int getNbHarvesting(String arg0) {
            return 0;
        }

        public long getTotalHarvestingTime() {
            return 0L;
        }
    }
}

