/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.tx;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.queue.QueueOperation;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;
import java.io.IOException;

public class TxnReservePollOperation
extends QueueOperation
implements WaitSupport {
    long reservedOfferId;
    String transactionId;

    public TxnReservePollOperation() {
    }

    public TxnReservePollOperation(String name, long timeoutMillis, long reservedOfferId, String transactionId) {
        super(name, timeoutMillis);
        this.reservedOfferId = reservedOfferId;
        this.transactionId = transactionId;
    }

    @Override
    public void run() throws Exception {
        this.response = this.getOrCreateContainer().txnPollReserve(this.reservedOfferId, this.transactionId);
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return this.getOrCreateContainer().getPollWaitNotifyKey();
    }

    @Override
    public boolean shouldWait() {
        return this.getWaitTimeoutMillis() != 0L && this.getOrCreateContainer().size() == 0;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    public int getId() {
        return 30;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.reservedOfferId);
        out.writeUTF(this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.reservedOfferId = in.readLong();
        this.transactionId = in.readUTF();
    }
}

