/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.ConnectionException;
import org.jivesoftware.openfire.auth.InternalUnauthenticatedException;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.plugin.rest.BasicAuth;
import org.jivesoftware.openfire.plugin.rest.RESTServicePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthFilter
implements ContainerRequestFilter {
    private static Logger LOG = LoggerFactory.getLogger(AuthFilter.class);
    @Context
    private HttpServletRequest httpRequest;
    private RESTServicePlugin plugin = (RESTServicePlugin)XMPPServer.getInstance().getPluginManager().getPlugin("restapi");

    public ContainerRequest filter(ContainerRequest containerRequest) throws WebApplicationException {
        String auth;
        if (!this.plugin.isEnabled()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if ("OPTIONS".equals(containerRequest.getMethod())) {
            return containerRequest;
        }
        if ("restapi/v1/userservice".equals(containerRequest.getPath())) {
            return containerRequest;
        }
        if (!this.plugin.getAllowedIPs().isEmpty()) {
            String ipAddress = this.httpRequest.getHeader("x-forwarded-for");
            if (ipAddress == null && (ipAddress = this.httpRequest.getHeader("X_FORWARDED_FOR")) == null && (ipAddress = this.httpRequest.getHeader("X-Forward-For")) == null) {
                ipAddress = this.httpRequest.getRemoteAddr();
            }
            if (!this.plugin.getAllowedIPs().contains(ipAddress)) {
                LOG.warn("REST API rejected service to IP address: " + ipAddress);
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        if ((auth = containerRequest.getHeaderValue("authorization")) == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if ("basic".equals(this.plugin.getHttpAuth())) {
            String[] usernameAndPassword = BasicAuth.decode(auth);
            if (usernameAndPassword == null || usernameAndPassword.length != 2) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            boolean userAdmin = AdminManager.getInstance().isUserAdmin(usernameAndPassword[0], true);
            if (!userAdmin) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            try {
                AuthFactory.authenticate((String)usernameAndPassword[0], (String)usernameAndPassword[1]);
            }
            catch (UnauthorizedException e) {
                LOG.warn("Wrong HTTP Basic Auth authorization", (Throwable)e);
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (ConnectionException e) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (InternalUnauthenticatedException e) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        } else if (!auth.equals(this.plugin.getSecret())) {
            LOG.warn("Wrong secret key authorization. Provided key: " + auth);
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return containerRequest;
    }
}

