/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.jabber.ContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.InfoRetreiver;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.RootContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.VolatileContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.VolatileContactJabberImpl;
import net.java.sip.communicator.service.customavatar.CustomAvatarService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.osgi.framework.ServiceReference;

public class ServerStoredContactListJabberImpl {
    private static final Logger logger = Logger.getLogger(ServerStoredContactListJabberImpl.class);
    private Roster roster = null;
    private final RootContactGroupJabberImpl rootGroup;
    private final OperationSetPersistentPresenceJabberImpl parentOperationSet;
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private Vector<ServerStoredGroupListener> serverStoredGroupListeners = new Vector();
    private ImageRetriever imageRetriever = null;
    private ChangeListener rosterChangeListener = null;
    private InfoRetreiver infoRetreiver = null;

    ServerStoredContactListJabberImpl(OperationSetPersistentPresenceJabberImpl parentOperationSet, ProtocolProviderServiceJabberImpl provider, InfoRetreiver infoRetreiver) {
        this.parentOperationSet = parentOperationSet;
        this.jabberProvider = provider;
        this.rootGroup = new RootContactGroupJabberImpl(this.jabberProvider);
        this.infoRetreiver = infoRetreiver;
    }

    public ContactGroup getRootGroup() {
        return this.rootGroup;
    }

    RosterEntry getRosterEntry(String user) {
        if (this.roster == null) {
            return null;
        }
        return this.roster.getEntry(user);
    }

    RosterGroup getRosterGroup(String name) {
        return this.roster.getGroup(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGroupListener(ServerStoredGroupListener listener) {
        Vector<ServerStoredGroupListener> vector = this.serverStoredGroupListeners;
        synchronized (vector) {
            if (!this.serverStoredGroupListeners.contains(listener)) {
                this.serverStoredGroupListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeGroupListener(ServerStoredGroupListener listener) {
        Vector<ServerStoredGroupListener> vector = this.serverStoredGroupListeners;
        synchronized (vector) {
            this.serverStoredGroupListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireGroupEvent(ContactGroupJabberImpl group, int eventID) {
        ArrayList<ServerStoredGroupListener> listeners;
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        ServerStoredGroupEvent evt = new ServerStoredGroupEvent((ContactGroup)group, eventID, this.parentOperationSet.getServerStoredContactListRoot(), (ProtocolProviderService)this.jabberProvider, (OperationSetPersistentPresence)this.parentOperationSet);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following grp event: " + evt));
        }
        Vector<ServerStoredGroupListener> vector = this.serverStoredGroupListeners;
        synchronized (vector) {
            listeners = new ArrayList<ServerStoredGroupListener>(this.serverStoredGroupListeners);
        }
        if (eventID == 1) {
            Iterator<Contact> iter = group.contacts();
            while (iter.hasNext()) {
                ContactJabberImpl c = (ContactJabberImpl)iter.next();
                if (this.roster == null) continue;
                this.parentOperationSet.firePresenceStatusChanged(this.roster.getPresence(c.getAddress()));
            }
        }
        for (ServerStoredGroupListener listener : listeners) {
            if (eventID == 2) {
                listener.groupRemoved(evt);
                continue;
            }
            if (eventID == 3) {
                listener.groupNameChanged(evt);
                continue;
            }
            if (eventID == 1) {
                listener.groupCreated(evt);
                continue;
            }
            if (eventID != 4) continue;
            listener.groupResolved(evt);
        }
    }

    void fireContactRemoved(ContactGroup parentGroup, ContactJabberImpl contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Removing " + contact.getAddress() + " from " + parentGroup.getGroupName()));
        }
        this.parentOperationSet.fireSubscriptionEvent((Contact)contact, parentGroup, 2);
    }

    private void fireContactMoved(ContactGroup oldParentGroup, ContactGroup newParentGroup, ContactJabberImpl contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        this.parentOperationSet.fireSubscriptionMovedEvent((Contact)contact, oldParentGroup, newParentGroup);
    }

    ProtocolProviderServiceJabberImpl getParentProvider() {
        return this.jabberProvider;
    }

    public ContactGroupJabberImpl findContactGroup(String name) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        name = name.trim();
        while (contactGroups.hasNext()) {
            ContactGroupJabberImpl contactGroup = (ContactGroupJabberImpl)contactGroups.next();
            if (!contactGroup.getGroupName().trim().equals(name)) continue;
            return contactGroup;
        }
        return null;
    }

    private ContactGroupJabberImpl findContactGroupByNameCopy(String name) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        name = name.trim();
        while (contactGroups.hasNext()) {
            ContactGroupJabberImpl contactGroup = (ContactGroupJabberImpl)contactGroups.next();
            if (contactGroup.getNameCopy() == null || !contactGroup.getNameCopy().trim().equals(name)) continue;
            return contactGroup;
        }
        return null;
    }

    public ContactJabberImpl findContactById(String id) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        ContactJabberImpl result = null;
        String userId = StringUtils.parseBareAddress((String)id);
        while (contactGroups.hasNext()) {
            ContactGroupJabberImpl contactGroup = (ContactGroupJabberImpl)contactGroups.next();
            result = contactGroup.findContact(userId);
            if (result == null) continue;
            return result;
        }
        ContactGroupJabberImpl volatileGroup = this.getNonPersistentGroup();
        if (volatileGroup != null && (result = volatileGroup.findContact(id)) != null) {
            return result;
        }
        return this.rootGroup.findContact(userId);
    }

    public ContactGroup findContactGroup(ContactJabberImpl child) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        String contactAddress = child.getAddress();
        while (contactGroups.hasNext()) {
            ContactGroupJabberImpl contactGroup = (ContactGroupJabberImpl)contactGroups.next();
            if (contactGroup.findContact(contactAddress) == null) continue;
            return contactGroup;
        }
        if (this.rootGroup.findContact(contactAddress) != null) {
            return this.rootGroup;
        }
        return null;
    }

    public void addContact(String id) throws OperationFailedException {
        this.addContact(null, id);
    }

    public void addContact(ContactGroup parent, String id) throws OperationFailedException {
        String completeID;
        ContactJabberImpl existingContact;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Adding contact " + id + " to parent=" + parent));
        }
        if ((existingContact = this.findContactById(completeID = this.parseAddressString(id))) != null && existingContact.isPersistent()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Contact " + completeID + " already exists in group " + this.findContactGroup(existingContact)));
            }
            throw new OperationFailedException("Contact " + completeID + " already exists.", 5);
        }
        try {
            String[] parentNames = null;
            if (parent != null) {
                parentNames = new String[]{parent.getGroupName()};
            }
            SmackConfiguration.setPacketReplyTimeout((int)45000);
            this.roster.createEntry(completeID, completeID, parentNames);
            SmackConfiguration.setPacketReplyTimeout((int)5000);
        }
        catch (XMPPException ex) {
            String errTxt = "Error adding new jabber entry";
            logger.error((Object)errTxt, (Throwable)ex);
            int errorCode = 4;
            XMPPError err = ex.getXMPPError();
            if (err != null) {
                if (err.getCode() > 400 && err.getCode() < 500) {
                    errorCode = 403;
                } else if (err.getCode() > 500) {
                    errorCode = 500;
                }
                errTxt = err.getCondition();
            }
            throw new OperationFailedException(errTxt, errorCode, (Throwable)ex);
        }
    }

    ContactJabberImpl createVolatileContact(String id, boolean isPrivateMessagingContact) {
        VolatileContactJabberImpl newVolatileContact = new VolatileContactJabberImpl(id, this, isPrivateMessagingContact);
        ContactGroupJabberImpl theVolatileGroup = this.getNonPersistentGroup();
        if (theVolatileGroup == null) {
            theVolatileGroup = new VolatileContactGroupJabberImpl(JabberActivator.getResources().getI18NString("service.gui.NOT_IN_CONTACT_LIST_GROUP_NAME"), this);
            theVolatileGroup.addContact(newVolatileContact);
            this.rootGroup.addSubGroup(theVolatileGroup);
            this.fireGroupEvent(theVolatileGroup, 1);
        } else {
            theVolatileGroup.addContact(newVolatileContact);
            this.fireContactAdded(theVolatileGroup, newVolatileContact);
        }
        return newVolatileContact;
    }

    public boolean isPrivateMessagingContact(String contactAddress) {
        ContactGroupJabberImpl theVolatileGroup = this.getNonPersistentGroup();
        if (theVolatileGroup == null) {
            return false;
        }
        ContactJabberImpl contact = theVolatileGroup.findContact(contactAddress);
        if (contact == null || !(contact instanceof VolatileContactJabberImpl)) {
            return false;
        }
        return ((VolatileContactJabberImpl)contact).isPrivateMessagingContact();
    }

    ContactJabberImpl createUnresolvedContact(ContactGroup parentGroup, String id) {
        ContactJabberImpl newUnresolvedContact = new ContactJabberImpl(id, this, false);
        if (parentGroup instanceof ContactGroupJabberImpl) {
            ((ContactGroupJabberImpl)parentGroup).addContact(newUnresolvedContact);
        } else if (parentGroup instanceof RootContactGroupJabberImpl) {
            ((RootContactGroupJabberImpl)parentGroup).addContact(newUnresolvedContact);
        }
        this.fireContactAdded(parentGroup, newUnresolvedContact);
        return newUnresolvedContact;
    }

    ContactGroupJabberImpl createUnresolvedContactGroup(String groupName) {
        ContactGroupJabberImpl newUnresolvedGroup = new ContactGroupJabberImpl(groupName, this);
        this.rootGroup.addSubGroup(newUnresolvedGroup);
        this.fireGroupEvent(newUnresolvedGroup, 1);
        return newUnresolvedGroup;
    }

    public void createGroup(String groupName) throws OperationFailedException {
        ContactGroupJabberImpl existingGroup;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating group: " + groupName));
        }
        if ((existingGroup = this.findContactGroup(groupName)) != null && existingGroup.isPersistent()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ContactGroup " + groupName + " already exists."));
            }
            throw new OperationFailedException("ContactGroup " + groupName + " already exists.", 6);
        }
        RosterGroup newRosterGroup = this.roster.createGroup(groupName);
        ContactGroupJabberImpl newGroup = new ContactGroupJabberImpl(newRosterGroup, new ArrayList().iterator(), this, true);
        this.rootGroup.addSubGroup(newGroup);
        this.fireGroupEvent(newGroup, 1);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Group " + groupName + " created."));
        }
    }

    public void removeGroup(ContactGroupJabberImpl groupToRemove) throws OperationFailedException {
        try {
            Vector<Contact> localCopy = new Vector<Contact>();
            Iterator<Object> iter = groupToRemove.contacts();
            while (iter.hasNext()) {
                localCopy.add(iter.next());
            }
            for (ContactJabberImpl contactJabberImpl : localCopy) {
                if (!contactJabberImpl.isPersistent()) continue;
                this.roster.removeEntry(contactJabberImpl.getSourceEntry());
            }
        }
        catch (XMPPException ex) {
            logger.error((Object)"Error removing group", (Throwable)ex);
            throw new OperationFailedException(ex.getMessage(), 1, (Throwable)ex);
        }
    }

    void removeContact(ContactJabberImpl contactToRemove) throws OperationFailedException {
        if (contactToRemove instanceof VolatileContactJabberImpl) {
            this.contactDeleted(contactToRemove);
            return;
        }
        try {
            RosterEntry entry = contactToRemove.getSourceEntry();
            if (entry != null) {
                this.roster.removeEntry(entry);
            }
        }
        catch (XMPPException ex) {
            String errTxt = "Error removing contact";
            logger.error((Object)errTxt, (Throwable)ex);
            int errorCode = 4;
            XMPPError err = ex.getXMPPError();
            if (err != null) {
                if (err.getCode() > 400 && err.getCode() < 500) {
                    errorCode = 403;
                } else if (err.getCode() > 500) {
                    errorCode = 500;
                }
                errTxt = err.getCondition();
            }
            throw new OperationFailedException(errTxt, errorCode, (Throwable)ex);
        }
    }

    public void renameGroup(ContactGroupJabberImpl groupToRename, String newName) {
        groupToRename.getSourceGroup().setName(newName);
        groupToRename.setNameCopy(newName);
    }

    public void moveContact(ContactJabberImpl contact, ContactGroupJabberImpl newParent) throws OperationFailedException {
        if (!contact.isPersistent()) {
            String contactAddress = null;
            contactAddress = contact instanceof VolatileContactJabberImpl && ((VolatileContactJabberImpl)contact).isPrivateMessagingContact() ? contact.getPersistableAddress() : contact.getAddress();
            try {
                this.addContact(newParent, contactAddress);
                return;
            }
            catch (OperationFailedException ex) {
                logger.error((Object)"Cannot move contact! ", (Throwable)ex);
                throw new OperationFailedException(ex.getMessage(), 1, (Throwable)ex);
            }
        }
        try {
            SmackConfiguration.setPacketReplyTimeout((int)45000);
            this.roster.createEntry(contact.getSourceEntry().getUser(), contact.getDisplayName(), new String[]{newParent.getGroupName()});
            SmackConfiguration.setPacketReplyTimeout((int)5000);
            newParent.addContact(contact);
        }
        catch (XMPPException ex) {
            logger.error((Object)"Cannot move contact! ", (Throwable)ex);
            throw new OperationFailedException(ex.getMessage(), 1, (Throwable)ex);
        }
    }

    void init(OperationSetPersistentPresenceJabberImpl.ContactChangesListener presenceChangeListener) {
        this.roster = this.jabberProvider.getConnection().getRoster();
        presenceChangeListener.storeEvents();
        this.roster.addRosterListener((RosterListener)presenceChangeListener);
        this.roster.setSubscriptionMode(Roster.SubscriptionMode.manual);
        this.initRoster();
        presenceChangeListener.processStoredEvents();
        this.rosterChangeListener = new ChangeListener();
        this.roster.addRosterListener((RosterListener)this.rosterChangeListener);
    }

    void cleanup() {
        if (this.imageRetriever != null) {
            this.imageRetriever.quit();
            this.imageRetriever = null;
        }
        if (this.roster != null) {
            this.roster.removeRosterListener((RosterListener)this.rosterChangeListener);
        }
        this.rosterChangeListener = null;
        this.roster = null;
    }

    private void initRoster() {
        ContactGroupJabberImpl group3;
        ContactJabberImpl contact2;
        if (this.roster.getUnfiledEntryCount() > 0) {
            for (RosterEntry item : this.roster.getUnfiledEntries()) {
                contact2 = this.findContactById(item.getUser());
                if (!ServerStoredContactListJabberImpl.isEntryDisplayable(item)) {
                    if (contact2 == null) continue;
                    ContactGroup parent = contact2.getParentContactGroup();
                    if (parent instanceof RootContactGroupJabberImpl) {
                        ((RootContactGroupJabberImpl)parent).removeContact(contact2);
                    } else {
                        ((ContactGroupJabberImpl)parent).removeContact(contact2);
                    }
                    this.fireContactRemoved(parent, contact2);
                    continue;
                }
                if (contact2 == null) {
                    contact2 = new ContactJabberImpl(item, this, true, true);
                    this.rootGroup.addContact(contact2);
                    this.fireContactAdded(this.rootGroup, contact2);
                } else {
                    ContactGroup group2 = contact2.getParentContactGroup();
                    if (!this.rootGroup.equals(group2)) {
                        this.contactMoved(group2, this.rootGroup, contact2);
                    }
                    contact2.setResolved(item);
                    this.fireContactResolved(this.rootGroup, contact2);
                }
                try {
                    this.parentOperationSet.firePresenceStatusChanged(this.roster.getPresence(item.getUser()));
                }
                catch (Throwable t) {
                    logger.error((Object)"Error processing presence", t);
                }
            }
        }
        Iterator<Contact> iter = this.rootGroup.contacts();
        ArrayList<ContactJabberImpl> contactsToRemove = new ArrayList<ContactJabberImpl>();
        while (iter.hasNext()) {
            contact2 = (ContactJabberImpl)iter.next();
            if (contact2.isResolved()) continue;
            contactsToRemove.add(contact2);
        }
        for (ContactJabberImpl contact2 : contactsToRemove) {
            this.rootGroup.removeContact(contact2);
            this.fireContactRemoved(this.rootGroup, contact2);
        }
        contactsToRemove.clear();
        for (RosterGroup item : this.roster.getGroups()) {
            group3 = this.findContactGroup(item.getName());
            if (group3 == null) continue;
            group3.setResolved(item);
            this.fireGroupEvent(group3, 4);
        }
        Iterator<ContactGroup> iterGroups = this.rootGroup.subgroups();
        ArrayList<ContactGroupJabberImpl> groupsToRemove = new ArrayList<ContactGroupJabberImpl>();
        while (iterGroups.hasNext()) {
            group3 = (ContactGroupJabberImpl)iterGroups.next();
            if (!group3.isResolved()) {
                groupsToRemove.add(group3);
            }
            Iterator<Contact> iterContacts = group3.contacts();
            while (iterContacts.hasNext()) {
                ContactJabberImpl contact3 = (ContactJabberImpl)iterContacts.next();
                if (contact3.isResolved()) continue;
                contactsToRemove.add(contact3);
            }
            for (ContactJabberImpl contact3 : contactsToRemove) {
                group3.removeContact(contact3);
                this.fireContactRemoved(group3, contact3);
            }
            contactsToRemove.clear();
        }
        for (ContactGroupJabberImpl group3 : groupsToRemove) {
            this.rootGroup.removeSubGroup(group3);
            this.fireGroupEvent(group3, 2);
        }
        for (RosterGroup item : this.roster.getGroups()) {
            ContactGroupJabberImpl group4 = this.findContactGroup(item.getName());
            if (group4 != null) continue;
            ContactGroupJabberImpl newGroup = new ContactGroupJabberImpl(item, item.getEntries().iterator(), this, true);
            this.rootGroup.addSubGroup(newGroup);
            this.fireGroupEvent(newGroup, 1);
            if (this.roster == null) continue;
            Iterator<Contact> cIter = newGroup.contacts();
            while (cIter.hasNext()) {
                String address = cIter.next().getAddress();
                this.parentOperationSet.firePresenceStatusChanged(this.roster.getPresence(address));
            }
        }
    }

    ContactGroupJabberImpl getNonPersistentGroup() {
        int i = 0;
        while (i < this.getRootGroup().countSubgroups()) {
            ContactGroupJabberImpl gr = (ContactGroupJabberImpl)this.getRootGroup().getGroup(i);
            if (!gr.isPersistent()) {
                return gr;
            }
            ++i;
        }
        return null;
    }

    void fireContactAdded(ContactGroup parentGroup, ContactJabberImpl contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        if (this.roster != null) {
            this.parentOperationSet.firePresenceStatusChanged(this.roster.getPresence(contact.getAddress()));
        }
        this.parentOperationSet.fireSubscriptionEvent((Contact)contact, parentGroup, 1);
    }

    void fireContactResolved(ContactGroup parentGroup, ContactJabberImpl contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        if (this.roster != null) {
            this.parentOperationSet.firePresenceStatusChanged(this.roster.getPresence(contact.getAddress()));
        }
        this.parentOperationSet.fireSubscriptionEvent((Contact)contact, parentGroup, 4);
    }

    protected void addContactForImageUpdate(ContactJabberImpl c) {
        if (this.imageRetriever == null) {
            this.imageRetriever = new ImageRetriever();
            this.imageRetriever.start();
        }
        this.imageRetriever.addContact(c);
    }

    static boolean isEntryDisplayable(RosterEntry entry) {
        if (entry.getType() == RosterPacket.ItemType.both || entry.getType() == RosterPacket.ItemType.to) {
            return true;
        }
        return (entry.getType() == RosterPacket.ItemType.none || entry.getType() == RosterPacket.ItemType.from) && (RosterPacket.ItemStatus.SUBSCRIPTION_PENDING.equals(entry.getStatus()) || entry.getGroups() != null && entry.getGroups().size() > 0);
    }

    private void contactDeleted(ContactJabberImpl contact) {
        ContactGroup group = this.findContactGroup(contact);
        if (group == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Could not find ParentGroup for deleted entry:" + contact.getAddress()));
            }
            return;
        }
        if (group instanceof ContactGroupJabberImpl) {
            ContactGroupJabberImpl groupImpl = (ContactGroupJabberImpl)group;
            groupImpl.removeContact(contact);
            if (groupImpl.countContacts() == 0) {
                this.rootGroup.removeSubGroup(groupImpl);
                this.fireContactRemoved(groupImpl, contact);
                this.fireGroupEvent(groupImpl, 2);
            } else {
                this.fireContactRemoved(groupImpl, contact);
            }
        } else if (group instanceof RootContactGroupJabberImpl) {
            this.rootGroup.removeContact(contact);
            this.fireContactRemoved(this.rootGroup, contact);
        }
    }

    private byte[] searchForCustomAvatar(String address) {
        ServiceReference[] refs;
        block5: {
            refs = JabberActivator.bundleContext.getServiceReferences(CustomAvatarService.class.getName(), null);
            if (refs != null) break block5;
            return null;
        }
        try {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference r = serviceReferenceArray[n2];
                CustomAvatarService avatarService = (CustomAvatarService)JabberActivator.bundleContext.getService(r);
                byte[] res = avatarService.getAvatar(address);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private void contactMoved(ContactGroup oldGroup, ContactGroup newGroup, ContactJabberImpl contact) {
        if (oldGroup instanceof ContactGroupJabberImpl) {
            ((ContactGroupJabberImpl)oldGroup).removeContact(contact);
        } else if (oldGroup instanceof RootContactGroupJabberImpl) {
            ((RootContactGroupJabberImpl)oldGroup).removeContact(contact);
        }
        if (newGroup instanceof ContactGroupJabberImpl) {
            ((ContactGroupJabberImpl)newGroup).addContact(contact);
        } else if (newGroup instanceof RootContactGroupJabberImpl) {
            ((RootContactGroupJabberImpl)newGroup).addContact(contact);
        }
        this.fireContactMoved(oldGroup, newGroup, contact);
        if (oldGroup instanceof ContactGroupJabberImpl && oldGroup.countContacts() == 0) {
            this.rootGroup.removeSubGroup((ContactGroupJabberImpl)oldGroup);
            this.fireGroupEvent((ContactGroupJabberImpl)oldGroup, 2);
        }
    }

    private String parseAddressString(String id) {
        if (id.indexOf("@") < 0) {
            AccountID accountID = this.jabberProvider.getAccountID();
            String userID = accountID.getUserID();
            int atIndex = userID.indexOf(64);
            String serverPart = atIndex > 0 ? userID.substring(atIndex + 1) : accountID.getService();
            return String.valueOf(id) + "@" + serverPart;
        }
        return id;
    }

    private class ChangeListener
    implements RosterListener {
        private ChangeListener() {
        }

        public void rosterError(XMPPError error, Packet packet) {
            logger.error((Object)("Error received in roster " + error.getCode() + " " + error.getMessage()));
        }

        public void entriesAdded(Collection<String> addresses) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("entriesAdded " + addresses));
            }
            for (String id : addresses) {
                this.addEntryToContactList(id);
            }
        }

        private ContactJabberImpl addEntryToContactList(String rosterEntryID) {
            RosterEntry entry = ServerStoredContactListJabberImpl.this.roster.getEntry(rosterEntryID);
            if (!ServerStoredContactListJabberImpl.isEntryDisplayable(entry)) {
                return null;
            }
            ContactJabberImpl contact = ServerStoredContactListJabberImpl.this.findContactById(entry.getUser());
            if (contact == null) {
                contact = this.findPrivateContactByRealId(entry.getUser());
            }
            if (contact != null) {
                if (contact.isPersistent()) {
                    contact.setResolved(entry);
                    return contact;
                }
                if (contact instanceof VolatileContactJabberImpl) {
                    ContactGroup oldParentGroup = contact.getParentContactGroup();
                    if (oldParentGroup instanceof ContactGroupJabberImpl && !oldParentGroup.isPersistent()) {
                        ((ContactGroupJabberImpl)oldParentGroup).removeContact(contact);
                        ServerStoredContactListJabberImpl.this.fireContactRemoved(oldParentGroup, contact);
                    }
                } else {
                    return contact;
                }
            }
            contact = new ContactJabberImpl(entry, ServerStoredContactListJabberImpl.this, true, true);
            if (entry.getGroups() == null || entry.getGroups().size() == 0) {
                ServerStoredContactListJabberImpl.this.rootGroup.addContact(contact);
                ServerStoredContactListJabberImpl.this.fireContactAdded(ServerStoredContactListJabberImpl.this.rootGroup, contact);
                return contact;
            }
            Iterator iterator = entry.getGroups().iterator();
            if (iterator.hasNext()) {
                RosterGroup group = (RosterGroup)iterator.next();
                ContactGroupJabberImpl parentGroup = ServerStoredContactListJabberImpl.this.findContactGroup(group.getName());
                if (parentGroup != null) {
                    parentGroup.addContact(contact);
                    ServerStoredContactListJabberImpl.this.fireContactAdded(ServerStoredContactListJabberImpl.this.findContactGroup(contact), contact);
                } else {
                    ContactGroupJabberImpl newGroup = new ContactGroupJabberImpl(group, group.getEntries().iterator(), ServerStoredContactListJabberImpl.this, true);
                    ServerStoredContactListJabberImpl.this.rootGroup.addSubGroup(newGroup);
                    ServerStoredContactListJabberImpl.this.fireGroupEvent(newGroup, 1);
                }
                return contact;
            }
            return contact;
        }

        private ContactJabberImpl findPrivateContactByRealId(String id) {
            ContactGroupJabberImpl volatileGroup = ServerStoredContactListJabberImpl.this.getNonPersistentGroup();
            if (volatileGroup == null) {
                return null;
            }
            Iterator<Contact> it = volatileGroup.contacts();
            while (it.hasNext()) {
                Contact contact = it.next();
                if (contact.getPersistableAddress() == null || !contact.getPersistableAddress().equals(StringUtils.parseBareAddress((String)id))) continue;
                return (ContactJabberImpl)contact;
            }
            return null;
        }

        public void entriesUpdated(Collection<String> addresses) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("entriesUpdated  " + addresses));
            }
            for (String contactID : addresses) {
                RosterEntry entry = ServerStoredContactListJabberImpl.this.roster.getEntry(contactID);
                ContactJabberImpl contact = this.addEntryToContactList(contactID);
                if (entry.getGroups().size() == 0) {
                    this.checkForRename(entry.getName(), contact);
                    ContactGroup contactGroup = contact.getParentContactGroup();
                    if (!ServerStoredContactListJabberImpl.this.rootGroup.equals(contactGroup)) {
                        ServerStoredContactListJabberImpl.this.contactMoved(contactGroup, ServerStoredContactListJabberImpl.this.rootGroup, contact);
                    }
                }
                for (RosterGroup gr : entry.getGroups()) {
                    ContactGroupJabberImpl cgr = ServerStoredContactListJabberImpl.this.findContactGroup(gr.getName());
                    if (cgr == null) {
                        ContactGroupJabberImpl group = ServerStoredContactListJabberImpl.this.findContactGroupByNameCopy(gr.getName());
                        if (group != null) {
                            group.setSourceGroup(gr);
                            ServerStoredContactListJabberImpl.this.fireGroupEvent(group, 3);
                        } else {
                            ContactGroup currentParentGroup = contact.getParentContactGroup();
                            if (currentParentGroup.countContacts() > 1) {
                                cgr = currentParentGroup;
                            } else {
                                boolean present = false;
                                for (RosterGroup entryGr : entry.getGroups()) {
                                    if (!entryGr.getName().equals(currentParentGroup.getGroupName())) continue;
                                    present = true;
                                    break;
                                }
                                if (!present && currentParentGroup instanceof ContactGroupJabberImpl) {
                                    ContactGroupJabberImpl currentGroup = (ContactGroupJabberImpl)currentParentGroup;
                                    currentGroup.setSourceGroup(gr);
                                    ServerStoredContactListJabberImpl.this.fireGroupEvent(currentGroup, 3);
                                }
                            }
                        }
                    }
                    if (cgr == null) continue;
                    ContactGroup contactGroup = contact.getParentContactGroup();
                    if (!gr.getName().equals(contactGroup.getGroupName())) {
                        ContactGroupJabberImpl newParentGroup = ServerStoredContactListJabberImpl.this.findContactGroup(gr.getName());
                        if (newParentGroup == null) {
                            newParentGroup = new ContactGroupJabberImpl(gr, new ArrayList().iterator(), ServerStoredContactListJabberImpl.this, true);
                            ServerStoredContactListJabberImpl.this.rootGroup.addSubGroup(newParentGroup);
                            ServerStoredContactListJabberImpl.this.fireGroupEvent(newParentGroup, 1);
                        }
                        ServerStoredContactListJabberImpl.this.contactMoved(contactGroup, newParentGroup, contact);
                        continue;
                    }
                    this.checkForRename(entry.getName(), contact);
                }
            }
        }

        private void checkForRename(String newValue, ContactJabberImpl contact) {
            if (newValue != null && !newValue.equals(contact.getServerDisplayName())) {
                String oldValue = contact.getServerDisplayName();
                contact.setServerDisplayName(newValue);
                ServerStoredContactListJabberImpl.this.parentOperationSet.fireContactPropertyChangeEvent("DisplayName", (Contact)contact, oldValue, newValue);
            }
        }

        public void entriesDeleted(Collection<String> addresses) {
            for (String address : addresses) {
                ContactJabberImpl contact;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("entry deleted " + address));
                }
                if ((contact = ServerStoredContactListJabberImpl.this.findContactById(address)) == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Could not find contact for deleted entry:" + address));
                    continue;
                }
                ServerStoredContactListJabberImpl.this.contactDeleted(contact);
            }
        }

        public void presenceChanged(Presence presence) {
        }
    }

    private class ImageRetriever
    extends Thread {
        private final List<ContactJabberImpl> contactsForUpdate = new Vector<ContactJabberImpl>();
        private boolean running = false;

        ImageRetriever() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Vector<ContactJabberImpl> copyContactsForUpdate = null;
                this.running = true;
                while (this.running) {
                    List<ContactJabberImpl> list = this.contactsForUpdate;
                    synchronized (list) {
                        if (this.contactsForUpdate.isEmpty()) {
                            this.contactsForUpdate.wait();
                        }
                        if (!this.running) {
                            return;
                        }
                        copyContactsForUpdate = new Vector<ContactJabberImpl>(this.contactsForUpdate);
                        this.contactsForUpdate.clear();
                    }
                    for (ContactJabberImpl contact : copyContactsForUpdate) {
                        byte[] imgBytes = this.getAvatar(contact);
                        if (imgBytes != null) {
                            byte[] oldImage = contact.getImage(false);
                            contact.setImage(imgBytes);
                            ServerStoredContactListJabberImpl.this.parentOperationSet.fireContactPropertyChangeEvent("Image", (Contact)contact, oldImage, imgBytes);
                            continue;
                        }
                        contact.setImage(new byte[0]);
                    }
                }
            }
            catch (InterruptedException ex) {
                logger.error((Object)"ImageRetriever error waiting will stop now!", (Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void addContact(ContactJabberImpl contact) {
            List<ContactJabberImpl> list = this.contactsForUpdate;
            synchronized (list) {
                if (!this.contactsForUpdate.contains((Object)contact)) {
                    this.contactsForUpdate.add(contact);
                    this.contactsForUpdate.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            List<ContactJabberImpl> list = this.contactsForUpdate;
            synchronized (list) {
                this.running = false;
                this.contactsForUpdate.notifyAll();
            }
        }

        private byte[] getAvatar(ContactJabberImpl contact) {
            byte[] result = null;
            try {
                Iterator<ServerStoredDetails.GenericDetail> iter = ServerStoredContactListJabberImpl.this.infoRetreiver.getDetails(contact.getAddress(), ServerStoredDetails.ImageDetail.class);
                if (iter.hasNext()) {
                    ServerStoredDetails.ImageDetail imgDetail = (ServerStoredDetails.ImageDetail)iter.next();
                    result = imgDetail.getBytes();
                }
                if (result == null) {
                    result = ServerStoredContactListJabberImpl.this.searchForCustomAvatar(contact.getAddress());
                }
                return result;
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cannot load image for contact " + (Object)((Object)contact) + ": " + ex.getMessage()), (Throwable)ex);
                }
                if ((result = ServerStoredContactListJabberImpl.this.searchForCustomAvatar(contact.getAddress())) == null) {
                    result = new byte[]{};
                }
                return result;
            }
        }
    }
}

