/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.spi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;

public class DNSJavaNameService
implements InvocationHandler {
    private static final String nsProperty = "sun.net.spi.nameservice.nameservers";
    private static final String domainProperty = "sun.net.spi.nameservice.domain";
    private static final String v6Property = "java.net.preferIPv6Addresses";
    private boolean preferV6 = false;
    private Name localhostName = null;
    private Object localhostNamedAddresses = null;
    private Object localhostAddresses = null;
    private boolean addressesLoaded = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected DNSJavaNameService() {
        String nameServers = System.getProperty(nsProperty);
        String domain = System.getProperty(domainProperty);
        String v6 = System.getProperty(v6Property);
        if (nameServers != null) {
            StringTokenizer st = new StringTokenizer(nameServers, ",");
            String[] servers = new String[st.countTokens()];
            int n = 0;
            while (st.hasMoreTokens()) {
                servers[n++] = st.nextToken();
            }
            try {
                ExtendedResolver res = new ExtendedResolver(servers);
                Lookup.setDefaultResolver(res);
            }
            catch (UnknownHostException e) {
                System.err.println("DNSJavaNameService: invalid sun.net.spi.nameservice.nameservers");
            }
        }
        if (domain != null) {
            try {
                Lookup.setDefaultSearchPath(new String[]{domain});
            }
            catch (TextParseException e) {
                System.err.println("DNSJavaNameService: invalid sun.net.spi.nameservice.domain");
            }
        }
        if (v6 != null && v6.equalsIgnoreCase("true")) {
            this.preferV6 = true;
        }
        try {
            Class<?> inClass = Class.forName("java.net.InetAddressImplFactory");
            Method create = inClass.getDeclaredMethod("create", null);
            create.setAccessible(true);
            Object impl = create.invoke(null, null);
            Class<?> clazz = Class.forName("java.net.InetAddressImpl");
            Method hostname = clazz.getMethod("getLocalHostName", new Class[0]);
            hostname.setAccessible(true);
            this.localhostName = new Name((String)hostname.invoke(impl, null));
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method lookup2 = clazz.getMethod("lookupAllHostAddr", classArray);
            lookup2.setAccessible(true);
            this.localhostNamedAddresses = lookup2.invoke(impl, this.localhostName.toString());
            this.localhostAddresses = lookup2.invoke(impl, "localhost");
            this.addressesLoaded = true;
        }
        catch (Exception e) {
            System.err.println("Could not obtain localhost: " + e);
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        block15: {
            try {
                if (method.getName().equals("getHostByAddr")) {
                    return this.getHostByAddr((byte[])args[0]);
                }
                if (!method.getName().equals("lookupAllHostAddr")) break block15;
                if (this.addressesLoaded) {
                    if (Name.fromString((String)args[0]).equals(this.localhostName)) {
                        return this.localhostNamedAddresses;
                    }
                    if (((String)args[0]).equals("localhost")) {
                        return this.localhostAddresses;
                    }
                }
                InetAddress[] addresses = this.lookupAllHostAddr((String)args[0]);
                Class<?> returnType = method.getReturnType();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("[Ljava.net.InetAddress;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (returnType.equals(clazz)) {
                    return addresses;
                }
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("[[B");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (returnType.equals(clazz2)) {
                    int naddrs = addresses.length;
                    byte[][] byteAddresses = new byte[naddrs][];
                    int i = 0;
                    while (i < naddrs) {
                        byte[] addr = addresses[i].getAddress();
                        byteAddresses[i] = addr;
                        ++i;
                    }
                    return byteAddresses;
                }
            }
            catch (Throwable e) {
                System.err.println("DNSJavaNameService: Unexpected error.");
                e.printStackTrace();
                throw e;
            }
        }
        throw new IllegalArgumentException("Unknown function name or arguments.");
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        Name name = null;
        try {
            name = new Name(host);
        }
        catch (TextParseException e) {
            throw new UnknownHostException(host);
        }
        Record[] records = null;
        if (this.preferV6) {
            records = new Lookup(name, 28).run();
        }
        if (records == null) {
            records = new Lookup(name, 1).run();
        }
        if (records == null && !this.preferV6) {
            records = new Lookup(name, 28).run();
        }
        if (records == null) {
            throw new UnknownHostException(host);
        }
        InetAddress[] array = new InetAddress[records.length];
        int i = 0;
        while (i < records.length) {
            if (records[i] instanceof ARecord) {
                ARecord a = (ARecord)records[i];
                array[i] = a.getAddress();
            } else {
                AAAARecord aaaa = (AAAARecord)records[i];
                array[i] = aaaa.getAddress();
            }
            ++i;
        }
        return array;
    }

    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        Name name = ReverseMap.fromAddress(InetAddress.getByAddress(addr));
        Record[] records = new Lookup(name, 12).run();
        if (records == null) {
            throw new UnknownHostException();
        }
        return ((PTRRecord)records[0]).getTarget().toString();
    }
}

