/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.speex;

import java.util.ArrayList;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import net.java.sip.communicator.impl.neomedia.codec.audio.speex.Speex;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;

public class SpeexResampler
extends AbstractCodec2 {
    private static final Format[] SUPPORTED_FORMATS;
    private static final double[] SUPPORTED_SAMPLE_RATES;
    private int channels;
    private int inputSampleRate;
    private int outputSampleRate;
    private long resampler;

    public SpeexResampler() {
        super("Speex Resampler", AudioFormat.class, SUPPORTED_FORMATS);
        this.inputFormats = SUPPORTED_FORMATS;
    }

    @Override
    protected void doClose() {
        if (this.resampler != 0L) {
            Speex.speex_resampler_destroy(this.resampler);
            this.resampler = 0L;
        }
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
    }

    @Override
    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        AudioFormat outAudioFormat;
        int outSampleRate;
        Format inFormat = inBuffer.getFormat();
        if (inFormat != null && inFormat != this.inputFormat && !inFormat.equals(this.inputFormat) && null == this.setInputFormat(inFormat)) {
            return 1;
        }
        inFormat = this.inputFormat;
        AudioFormat inAudioFormat = (AudioFormat)inFormat;
        int inSampleRate = (int)inAudioFormat.getSampleRate();
        if (inSampleRate == (outSampleRate = (int)(outAudioFormat = (AudioFormat)this.getOutputFormat()).getSampleRate())) {
            Class<?> inDataType = inAudioFormat.getDataType();
            Class<?> outDataType = outAudioFormat.getDataType();
            if (Format.byteArray.equals(inDataType)) {
                byte[] input = (byte[])inBuffer.getData();
                if (Format.byteArray.equals(outDataType)) {
                    int length = input == null ? 0 : input.length;
                    byte[] output = SpeexResampler.validateByteArraySize(outBuffer, length, false);
                    if (input != null && output != null) {
                        System.arraycopy(input, 0, output, 0, length);
                    }
                    outBuffer.setFormat(inBuffer.getFormat());
                    outBuffer.setLength(inBuffer.getLength());
                    outBuffer.setOffset(inBuffer.getOffset());
                } else {
                    int inLength = inBuffer.getLength();
                    int outOffset = 0;
                    int outLength = inLength / 2;
                    short[] output = this.validateShortArraySize(outBuffer, outLength);
                    int i = inBuffer.getOffset();
                    for (int o = outOffset; o < outLength; ++o) {
                        output[o] = (short)(input[i++] & 0xFF | (input[i++] & 0xFF) << 8);
                    }
                    outBuffer.setFormat(outAudioFormat);
                    outBuffer.setLength(outLength);
                    outBuffer.setOffset(outOffset);
                }
            } else {
                short[] input = (short[])inBuffer.getData();
                if (Format.byteArray.equals(outDataType)) {
                    int inLength = inBuffer.getLength();
                    int outOffset = 0;
                    int outLength = inLength * 2;
                    byte[] output = SpeexResampler.validateByteArraySize(outBuffer, outLength, false);
                    int i = inBuffer.getOffset();
                    int o = outOffset;
                    while (o < outLength) {
                        short s = input[i];
                        output[o++] = (byte)(s & 0xFF);
                        output[o++] = (byte)((s & 0xFF00) >>> 8);
                        ++i;
                    }
                    outBuffer.setFormat(outAudioFormat);
                    outBuffer.setLength(outLength);
                    outBuffer.setOffset(outOffset);
                } else {
                    int length = input == null ? 0 : input.length;
                    short[] output = this.validateShortArraySize(outBuffer, length);
                    if (input != null && output != null) {
                        System.arraycopy(input, 0, output, 0, length);
                    }
                    outBuffer.setFormat(inBuffer.getFormat());
                    outBuffer.setLength(inBuffer.getLength());
                    outBuffer.setOffset(inBuffer.getOffset());
                }
            }
        } else {
            boolean channelsHaveChanged;
            int channels = inAudioFormat.getChannels();
            if (outAudioFormat.getChannels() != channels) {
                return 1;
            }
            boolean bl = channelsHaveChanged = this.channels != channels;
            if (channelsHaveChanged || this.inputSampleRate != inSampleRate || this.outputSampleRate != outSampleRate) {
                if (channelsHaveChanged && this.resampler != 0L) {
                    Speex.speex_resampler_destroy(this.resampler);
                    this.resampler = 0L;
                }
                if (this.resampler == 0L) {
                    this.resampler = Speex.speex_resampler_init(channels, inSampleRate, outSampleRate, 3, 0L);
                } else {
                    Speex.speex_resampler_set_rate(this.resampler, inSampleRate, outSampleRate);
                }
                if (this.resampler != 0L) {
                    this.inputSampleRate = inSampleRate;
                    this.outputSampleRate = outSampleRate;
                    this.channels = channels;
                }
            }
            if (this.resampler == 0L) {
                return 1;
            }
            byte[] in = (byte[])inBuffer.getData();
            int inLength = inBuffer.getLength();
            int frameSize = channels * (inAudioFormat.getSampleSizeInBits() / 8);
            int inSampleCount = inLength / frameSize;
            int outSampleCount = inSampleCount * outSampleRate / inSampleRate;
            byte[] out = SpeexResampler.validateByteArraySize(outBuffer, outSampleCount * frameSize, false);
            outSampleCount = inSampleCount == 0 ? 0 : Speex.speex_resampler_process_interleaved_int(this.resampler, in, inBuffer.getOffset(), inSampleCount, out, 0, outSampleCount);
            outBuffer.setFormat(outAudioFormat);
            outBuffer.setLength(outSampleCount * frameSize);
            outBuffer.setOffset(0);
        }
        outBuffer.setDuration(inBuffer.getDuration());
        outBuffer.setEOM(inBuffer.isEOM());
        outBuffer.setFlags(inBuffer.getFlags());
        outBuffer.setHeader(inBuffer.getHeader());
        outBuffer.setSequenceNumber(inBuffer.getSequenceNumber());
        outBuffer.setTimeStamp(inBuffer.getTimeStamp());
        return 0;
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        Class<?> inDataType = inputFormat.getDataType();
        ArrayList<Format> matchingOutputFormats = new ArrayList<Format>();
        if (inputFormat instanceof AudioFormat) {
            AudioFormat inAudioFormat = (AudioFormat)inputFormat;
            int inChannels = inAudioFormat.getChannels();
            double inSampleRate = inAudioFormat.getSampleRate();
            for (Format supportedFormat : SUPPORTED_FORMATS) {
                AudioFormat supportedAudioFormat = (AudioFormat)supportedFormat;
                if (supportedAudioFormat.getChannels() != inChannels || (!Format.byteArray.equals(supportedFormat.getDataType()) || !Format.byteArray.equals(inDataType)) && supportedAudioFormat.getSampleRate() != inSampleRate) continue;
                matchingOutputFormats.add(supportedFormat);
            }
        }
        return matchingOutputFormats.toArray(new Format[matchingOutputFormats.size()]);
    }

    @Override
    public Format setInputFormat(Format format) {
        AudioFormat inFormat = (AudioFormat)super.setInputFormat(format);
        if (inFormat != null) {
            Class<?> outDataType;
            double outSampleRate;
            if (this.outputFormat == null) {
                outSampleRate = inFormat.getSampleRate();
                outDataType = inFormat.getDataType();
            } else {
                AudioFormat outAudioFormat = (AudioFormat)this.outputFormat;
                outSampleRate = outAudioFormat.getSampleRate();
                outDataType = outAudioFormat.getDataType();
                if (outSampleRate != inFormat.getSampleRate()) {
                    outDataType = inFormat.getDataType();
                }
            }
            this.setOutputFormat(new AudioFormat(inFormat.getEncoding(), outSampleRate, inFormat.getSampleSizeInBits(), inFormat.getChannels(), inFormat.getEndian(), inFormat.getSigned(), -1, -1.0, outDataType));
        }
        return inFormat;
    }

    static {
        SUPPORTED_SAMPLE_RATES = new double[]{8000.0, 11025.0, 12000.0, 16000.0, 22050.0, 24000.0, 32000.0, 44100.0, 48000.0, -1.0};
        Speex.assertSpeexIsFunctional();
        int supportedCount = SUPPORTED_SAMPLE_RATES.length;
        SUPPORTED_FORMATS = new Format[4 * supportedCount];
        for (int i = 0; i < supportedCount; ++i) {
            int j = 4 * i;
            SpeexResampler.SUPPORTED_FORMATS[j] = new AudioFormat("LINEAR", SUPPORTED_SAMPLE_RATES[i], 16, 1, 0, 1, -1, -1.0, Format.byteArray);
            SpeexResampler.SUPPORTED_FORMATS[j + 1] = new AudioFormat("LINEAR", SUPPORTED_SAMPLE_RATES[i], 16, 1, 0, 1, -1, -1.0, Format.shortArray);
            SpeexResampler.SUPPORTED_FORMATS[j + 2] = new AudioFormat("LINEAR", SUPPORTED_SAMPLE_RATES[i], 16, 2, 0, 1, -1, -1.0, Format.byteArray);
            SpeexResampler.SUPPORTED_FORMATS[j + 3] = new AudioFormat("LINEAR", SUPPORTED_SAMPLE_RATES[i], 16, 2, 0, 1, -1, -1.0, Format.shortArray);
        }
    }
}

