/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g729;

import javax.media.Buffer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.ArrayIOUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.g729.Decoder;

public class JavaDecoder
extends AbstractCodec2 {
    private static final short BIT_0 = 127;
    private static final short BIT_1 = 129;
    private static final int L_FRAME = 80;
    private static final int SERIAL_SIZE = 82;
    private static final short SIZE_WORD = 80;
    private static final short SYNC_WORD = 27425;
    private static final int INPUT_FRAME_SIZE_IN_BYTES = 10;
    private static final int OUTPUT_FRAME_SIZE_IN_BYTES = 160;
    private Decoder decoder;
    private short[] serial;
    private short[] sp16;

    public JavaDecoder() {
        super("G.729 Decoder", AudioFormat.class, new AudioFormat[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)});
        this.inputFormats = new AudioFormat[]{new AudioFormat("g729/rtp", 8000.0, -1, 1)};
    }

    private void depacketize(byte[] inputFrame, int inputFrameOffset, short[] serial) {
        serial[0] = 27425;
        serial[1] = 80;
        for (int s = 0; s < 80; ++s) {
            int input = inputFrame[inputFrameOffset + s / 8];
            serial[2 + s] = 0 != (input &= 1 << 7 - s % 8) ? 129 : 127;
        }
    }

    @Override
    protected void doClose() {
        this.serial = null;
        this.sp16 = null;
        this.decoder = null;
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.serial = new short[82];
        this.sp16 = new short[80];
        this.decoder = new Decoder();
    }

    @Override
    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        int inLength = inBuffer.getLength();
        if (inLength < 10) {
            this.discardOutputBuffer(outBuffer);
            return 4;
        }
        byte[] in = (byte[])inBuffer.getData();
        int inOffset = inBuffer.getOffset();
        this.depacketize(in, inOffset, this.serial);
        inBuffer.setLength(inLength -= 10);
        inBuffer.setOffset(inOffset += 10);
        this.decoder.process(this.serial, this.sp16);
        byte[] out = JavaDecoder.validateByteArraySize(outBuffer, outBuffer.getOffset() + 160, true);
        JavaDecoder.writeShorts(this.sp16, out, outBuffer.getOffset());
        outBuffer.setLength(160);
        int ret = 0;
        if (inLength > 0) {
            ret |= 2;
        }
        return ret;
    }

    private static void writeShorts(short[] in, byte[] out, int outOffset) {
        int i = 0;
        int o = outOffset;
        while (i < in.length) {
            ArrayIOUtils.writeShort(in[i], out, o);
            ++i;
            o += 2;
        }
    }
}

