/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class Ice4jLogFormatter
extends Formatter {
    static long startTime = System.currentTimeMillis();
    private static String lineSeparator = System.getProperty("line.separator");
    private static DecimalFormat twoDigFmt = new DecimalFormat("00");
    private static DecimalFormat threeDigFmt = new DecimalFormat("000");

    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        int millis = cal.get(14);
        sb.append(twoDigFmt.format(hour)).append(':');
        sb.append(twoDigFmt.format(minutes)).append(':');
        sb.append(twoDigFmt.format(seconds)).append('.');
        sb.append(threeDigFmt.format(millis)).append(' ');
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        int lineNumber = this.inferCaller(record);
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            loggerName = record.getSourceClassName();
        }
        if (loggerName.startsWith("net.java.sip.communicator.")) {
            sb.append(loggerName.substring("net.java.sip.communicator.".length()));
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(".");
            sb.append(record.getSourceMethodName());
            if (lineNumber != -1) {
                sb.append("().").append(Integer.toString(lineNumber));
            } else {
                sb.append("()");
            }
        }
        sb.append(" ");
        sb.append(record.getMessage());
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private int inferCaller(LogRecord record) {
        StackTraceElement frame;
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int lineNumber = -1;
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals("net.java.sip.communicator.util.Logger"); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            lineNumber = stack[ix].getLineNumber();
            cname = frame.getClassName();
            if (!cname.equals("net.java.sip.communicator.util.Logger")) {
                record.setSourceClassName(cname);
                record.setSourceMethodName(frame.getMethodName());
                break;
            }
            ++ix;
        }
        return lineNumber;
    }
}

