/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.nearcache.impl.store;

import com.hazelcast.cache.impl.nearcache.NearCacheContext;
import com.hazelcast.cache.impl.nearcache.impl.record.NearCacheDataRecord;
import com.hazelcast.cache.impl.nearcache.impl.store.BaseHeapNearCacheRecordStore;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;

public class NearCacheDataRecordStore<K, V>
extends BaseHeapNearCacheRecordStore<K, V, NearCacheDataRecord> {
    public NearCacheDataRecordStore(NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext) {
        super(nearCacheConfig, nearCacheContext);
    }

    @Override
    protected long getKeyStorageMemoryCost(K key) {
        if (key instanceof Data) {
            return REFERENCE_SIZE + ((Data)key).getHeapCost();
        }
        return 0L;
    }

    @Override
    protected long getRecordStorageMemoryCost(NearCacheDataRecord record) {
        if (record == null) {
            return 0L;
        }
        Data value = (Data)record.getValue();
        return REFERENCE_SIZE + REFERENCE_SIZE + (value != null ? value.getHeapCost() : 0) + 24 + REFERENCE_SIZE + 4;
    }

    @Override
    protected NearCacheDataRecord valueToRecord(V value) {
        Data data = this.toData(value);
        long creationTime = Clock.currentTimeMillis();
        if (this.timeToLiveMillis > 0L) {
            return new NearCacheDataRecord(data, creationTime, creationTime + this.timeToLiveMillis);
        }
        return new NearCacheDataRecord(data, creationTime, -1L);
    }

    @Override
    protected V recordToValue(NearCacheDataRecord record) {
        Data data = (Data)record.getValue();
        return this.dataToValue(data);
    }

    @Override
    protected void putToRecord(NearCacheDataRecord record, V value) {
        record.setValue(this.toData(value));
    }

    @Override
    public Object selectToSave(Object ... candidates) {
        Object selectedCandidate = null;
        if (candidates != null && candidates.length > 0) {
            for (Object candidate : candidates) {
                if (!(candidate instanceof Data)) continue;
                selectedCandidate = candidate;
                break;
            }
            if (selectedCandidate != null) {
                return selectedCandidate;
            }
            for (Object candidate : candidates) {
                if (candidate == null) continue;
                selectedCandidate = candidate;
                break;
            }
        }
        return selectedCandidate;
    }
}

