/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceTcpSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.MultiplexedDatagramSocket;
import org.ice4j.socket.MultiplexedSocket;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.socket.MultiplexingSocket;
import org.ice4j.socket.StunDatagramPacketFilter;
import org.ice4j.stack.StunStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalCandidate
extends Candidate<LocalCandidate> {
    private CandidateExtendedType extendedType = null;
    private String ufrag = null;
    private static final Logger logger = Logger.getLogger(HostCandidate.class.getName());

    public LocalCandidate(TransportAddress transportAddress, Component parentComponent, CandidateType type, CandidateExtendedType extendedType, LocalCandidate relatedCandidate) {
        super(transportAddress, parentComponent, type, relatedCandidate);
        this.extendedType = extendedType;
    }

    public DatagramSocket getDatagramSocket() {
        return this.getIceSocketWrapper().getUDPSocket();
    }

    public Socket getSocket() {
        return this.getIceSocketWrapper().getTCPSocket();
    }

    protected abstract IceSocketWrapper getIceSocketWrapper();

    public IceSocketWrapper getStunSocket(TransportAddress serverAddress) {
        IceSocketWrapper hostSocket = this.getIceSocketWrapper();
        if (hostSocket.getTCPSocket() != null) {
            Socket tcpSocket = hostSocket.getTCPSocket();
            MultiplexedSocket tcpStunSocket = null;
            if (tcpSocket instanceof MultiplexingSocket) {
                StunDatagramPacketFilter stunDatagramPacketFilter = this.createStunDatagramPacketFilter(serverAddress);
                SocketException exception = null;
                try {
                    tcpStunSocket = ((MultiplexingSocket)tcpSocket).getSocket(stunDatagramPacketFilter);
                }
                catch (SocketException sex) {
                    logger.log(Level.SEVERE, "Failed to acquire Socket specific to STUN communication.", sex);
                    exception = sex;
                }
                if (tcpStunSocket == null) {
                    throw new IllegalStateException("Failed to acquire Socket specific to STUN communication", exception);
                }
            } else {
                throw new IllegalStateException("The socket of " + this.getClass().getSimpleName() + " must be a MultiplexingSocket " + "instance");
            }
            IceTcpSocketWrapper stunSocket = null;
            try {
                stunSocket = new IceTcpSocketWrapper(tcpStunSocket);
            }
            catch (IOException e) {
                logger.info("Failed to create IceTcpSocketWrapper " + e);
            }
            return stunSocket;
        }
        if (hostSocket.getUDPSocket() != null) {
            DatagramSocket udpSocket = hostSocket.getUDPSocket();
            MultiplexedDatagramSocket udpStunSocket = null;
            if (udpSocket instanceof MultiplexingDatagramSocket) {
                StunDatagramPacketFilter stunDatagramPacketFilter = this.createStunDatagramPacketFilter(serverAddress);
                SocketException exception = null;
                try {
                    udpStunSocket = ((MultiplexingDatagramSocket)udpSocket).getSocket(stunDatagramPacketFilter);
                }
                catch (SocketException sex) {
                    logger.log(Level.SEVERE, "Failed to acquire DatagramSocket specific to STUN communication.", sex);
                    exception = sex;
                }
                if (udpStunSocket == null) {
                    throw new IllegalStateException("Failed to acquire DatagramSocket specific to STUN communication", exception);
                }
            } else {
                throw new IllegalStateException("The socket of " + this.getClass().getSimpleName() + " must be a MultiplexingDatagramSocket " + "instance");
            }
            return new IceUdpSocketWrapper(udpStunSocket);
        }
        return null;
    }

    public StunStack getStunStack() {
        return this.getParentComponent().getParentStream().getParentAgent().getStunStack();
    }

    protected StunDatagramPacketFilter createStunDatagramPacketFilter(TransportAddress serverAddress) {
        return new StunDatagramPacketFilter(serverAddress);
    }

    protected void free() {
        LocalCandidate base;
        IceSocketWrapper socket = this.getIceSocketWrapper();
        if (socket != null && ((base = (LocalCandidate)this.getBase()) == null || base == this || base.getIceSocketWrapper() != socket)) {
            this.getStunStack().removeSocket(this.getTransportAddress());
            socket.close();
        }
    }

    @Override
    public boolean isDefault() {
        Component parentCmp = this.getParentComponent();
        return parentCmp != null && this.equals(parentCmp.getDefaultCandidate());
    }

    public void setUfrag(String ufrag) {
        this.ufrag = ufrag;
    }

    @Override
    public String getUfrag() {
        return this.ufrag;
    }

    public CandidateExtendedType getExtendedType() {
        return this.extendedType;
    }

    public void setExtendedType(CandidateExtendedType extendedType) {
        this.extendedType = extendedType;
    }

    @Override
    protected LocalCandidate findRelatedCandidate(TransportAddress relatedAddress) {
        return this.getParentComponent().findLocalCandidate(relatedAddress);
    }
}

