/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jolokia.discovery.AgentDetails;
import org.jolokia.discovery.DiscoveryIncomingMessage;
import org.jolokia.discovery.DiscoveryOutgoingMessage;
import org.jolokia.util.LogHandler;
import org.jolokia.util.NetworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MulticastUtil {
    public static final String JOLOKIA_MULTICAST_GROUP = "239.192.48.84";
    public static final int JOLOKIA_MULTICAST_PORT = 24884;

    private MulticastUtil() {
    }

    static MulticastSocket newMulticastSocket(InetAddress pAddress, LogHandler pLogHandler) throws IOException {
        InetSocketAddress socketAddress = new InetSocketAddress(JOLOKIA_MULTICAST_GROUP, 24884);
        MulticastSocket socket = new MulticastSocket(24884);
        socket.setReuseAddress(true);
        MulticastUtil.setOutgoingInterfaceForMulticastRequest(pAddress, socket);
        socket.setTimeToLive(255);
        if (MulticastUtil.joinMcGroupsOnAllNetworkInterfaces(socket, socketAddress, pLogHandler) == 0) {
            throw new IOException("Couldn't join multicast group " + socketAddress + " on any network interfaces");
        }
        return socket;
    }

    public static List<DiscoveryIncomingMessage> sendQueryAndCollectAnswers(DiscoveryOutgoingMessage pOutMsg, int pTimeout) throws IOException {
        return MulticastUtil.sendQueryAndCollectAnswers(pOutMsg, pTimeout, LogHandler.QUIET);
    }

    public static List<DiscoveryIncomingMessage> sendQueryAndCollectAnswers(DiscoveryOutgoingMessage pOutMsg, int pTimeout, LogHandler pLogHandler) throws IOException {
        List<Future<List<DiscoveryIncomingMessage>>> futures = MulticastUtil.sendDiscoveryRequests(pOutMsg, pTimeout, pLogHandler);
        return MulticastUtil.collectIncomingMessages(pTimeout, futures, pLogHandler);
    }

    private static List<Future<List<DiscoveryIncomingMessage>>> sendDiscoveryRequests(DiscoveryOutgoingMessage pOutMsg, int pTimeout, LogHandler pLogHandler) throws SocketException, UnknownHostException {
        List<InetAddress> addresses = MulticastUtil.getMulticastAddresses();
        ExecutorService executor = Executors.newFixedThreadPool(addresses.size());
        ArrayList<Future<List<DiscoveryIncomingMessage>>> futures = new ArrayList<Future<List<DiscoveryIncomingMessage>>>(addresses.size());
        for (InetAddress address : addresses) {
            DatagramPacket out = pOutMsg.createDatagramPacket(InetAddress.getByName(JOLOKIA_MULTICAST_GROUP), 24884);
            FindAgentsCallable findAgentsCallable = new FindAgentsCallable(address, out, pTimeout, pLogHandler);
            futures.add(executor.submit(findAgentsCallable));
        }
        executor.shutdownNow();
        return futures;
    }

    private static List<InetAddress> getMulticastAddresses() throws SocketException, UnknownHostException {
        List<InetAddress> addresses = NetworkUtil.getMulticastAddresses();
        if (addresses.size() == 0) {
            throw new UnknownHostException("Cannot find address of local host which can be used for sending discovery request");
        }
        return addresses;
    }

    private static List<DiscoveryIncomingMessage> collectIncomingMessages(int pTimeout, List<Future<List<DiscoveryIncomingMessage>>> pFutures, LogHandler pLogHandler) {
        ArrayList<DiscoveryIncomingMessage> ret = new ArrayList<DiscoveryIncomingMessage>();
        HashSet<String> seen = new HashSet<String>();
        for (Future<List<DiscoveryIncomingMessage>> future : pFutures) {
            try {
                List<DiscoveryIncomingMessage> inMsgs = future.get(pTimeout + 500, TimeUnit.MILLISECONDS);
                for (DiscoveryIncomingMessage inMsg : inMsgs) {
                    AgentDetails details = inMsg.getAgentDetails();
                    String id = details.getAgentId();
                    if (seen.contains(id)) continue;
                    ret.add(inMsg);
                    seen.add(id);
                }
            }
            catch (InterruptedException exp) {
            }
            catch (ExecutionException e) {
                pLogHandler.debug("--> Exception during lookup: " + e);
            }
            catch (TimeoutException e) {
            }
        }
        return ret;
    }

    private static int joinMcGroupsOnAllNetworkInterfaces(MulticastSocket pSocket, InetSocketAddress pSocketAddress, LogHandler pLogHandler) throws IOException {
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        int interfacesJoined = 0;
        while (nifs.hasMoreElements()) {
            NetworkInterface n = nifs.nextElement();
            if (!NetworkUtil.isMulticastSupported(n)) continue;
            try {
                pSocket.joinGroup(pSocketAddress, n);
                ++interfacesJoined;
            }
            catch (IOException exp) {
                pLogHandler.info("Cannot join multicast group on NIF " + n.getDisplayName() + ": " + exp.getMessage());
            }
        }
        return interfacesJoined;
    }

    private static void setOutgoingInterfaceForMulticastRequest(InetAddress pAddress, MulticastSocket pSocket) throws SocketException, UnknownHostException {
        NetworkInterface nif = NetworkInterface.getByInetAddress(pAddress);
        if (nif != null) {
            pSocket.setNetworkInterface(nif);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FindAgentsCallable
    implements Callable<List<DiscoveryIncomingMessage>> {
        private final InetAddress address;
        private final DatagramPacket outPacket;
        private final int timeout;
        private final LogHandler logHandler;

        private FindAgentsCallable(InetAddress pAddress, DatagramPacket pOutPacket, int pTimeout, LogHandler pLogHandler) {
            this.address = pAddress;
            this.outPacket = pOutPacket;
            this.timeout = pTimeout;
            this.logHandler = pLogHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<DiscoveryIncomingMessage> call() throws SocketException {
            DatagramSocket socket = new DatagramSocket(0, this.address);
            ArrayList<DiscoveryIncomingMessage> ret = new ArrayList<DiscoveryIncomingMessage>();
            try {
                socket.setSoTimeout(this.timeout);
                this.logHandler.debug(this.address + "--> Sending");
                socket.send(this.outPacket);
                try {
                    while (true) {
                        byte[] buf = new byte[8972];
                        DatagramPacket in = new DatagramPacket(buf, buf.length);
                        socket.receive(in);
                        this.logHandler.debug(this.address + "--> Received answer from " + in.getAddress());
                        this.addIncomingMessage(ret, in);
                    }
                }
                catch (SocketTimeoutException exp2) {
                    this.logHandler.debug(this.address + "--> Timeout");
                    ArrayList<DiscoveryIncomingMessage> exp2 = ret;
                    return exp2;
                }
            }
            catch (IOException exp) {
                this.logHandler.debug(this.address + "--> Could not send multicast over : " + exp);
                ArrayList<DiscoveryIncomingMessage> arrayList = ret;
                return arrayList;
            }
            finally {
                socket.close();
            }
        }

        private void addIncomingMessage(List<DiscoveryIncomingMessage> ret, DatagramPacket in) {
            try {
                DiscoveryIncomingMessage inMsg = new DiscoveryIncomingMessage(in);
                if (!inMsg.isQuery()) {
                    ret.add(inMsg);
                }
            }
            catch (Exception exp) {
                this.logHandler.debug("Invalid incoming package from " + in.getAddress() + "  --> " + exp + ". Ignoring");
            }
        }
    }
}

