/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.icqconstants;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.util.Logger;

public class IcqStatusEnum
extends PresenceStatus {
    private static Logger logger = Logger.getLogger(IcqStatusEnum.class);
    public static final IcqStatusEnum FREE_FOR_CHAT = new IcqStatusEnum(85, "Free For Chat", IcqStatusEnum.loadIcon("resources/images/protocol/icq/icq16x16-ffc.png"));
    public static final IcqStatusEnum ONLINE = new IcqStatusEnum(65, "Online", IcqStatusEnum.loadIcon("resources/images/protocol/icq/icq16x16-online.png"));
    public static final IcqStatusEnum AWAY = new IcqStatusEnum(48, "Away", IcqStatusEnum.loadIcon("resources/images/protocol/icq/icq16x16-away.png"));
    public static final IcqStatusEnum INVISIBLE = new IcqStatusEnum(45, "Invisible", IcqStatusEnum.loadIcon("resources/images/protocol/icq/icq16x16-invisible.png"));
    public static final IcqStatusEnum NOT_AVAILABLE = new IcqStatusEnum(35, "Not Available", IcqStatusEnum.loadIcon("resources/images/protocol/icq/icq16x16-na.png"));
    public static final IcqStatusEnum DO_NOT_DISTURB = new IcqStatusEnum(30, "Do Not Disturb", IcqStatusEnum.loadIcon("resources/images/protocol/icq/icq16x16-dnd.png"));
    public static final IcqStatusEnum OCCUPIED = new IcqStatusEnum(25, "Occupied", IcqStatusEnum.loadIcon("resources/images/protocol/icq/icq16x16-occupied.png"));
    public static final IcqStatusEnum OFFLINE = new IcqStatusEnum(0, "Offline", IcqStatusEnum.loadIcon("resources/images/protocol/icq/icq16x16-offline.png"));
    public static final ArrayList<IcqStatusEnum> icqStatusSet = new ArrayList();

    protected IcqStatusEnum(int status, String statusName, byte[] statusIcon) {
        super(status, statusName, statusIcon);
    }

    public static byte[] loadIcon(String imagePath) {
        InputStream is = IcqStatusEnum.class.getClassLoader().getResourceAsStream(imagePath);
        if (is == null) {
            return null;
        }
        byte[] icon = null;
        try {
            icon = new byte[is.available()];
            is.read(icon);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load icon: " + imagePath), (Throwable)e);
        }
        return icon;
    }

    static {
        icqStatusSet.add(FREE_FOR_CHAT);
        icqStatusSet.add(ONLINE);
        icqStatusSet.add(INVISIBLE);
        icqStatusSet.add(AWAY);
        icqStatusSet.add(NOT_AVAILABLE);
        icqStatusSet.add(DO_NOT_DISTURB);
        icqStatusSet.add(OCCUPIED);
        icqStatusSet.add(OFFLINE);
    }
}

