/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;

public class CallPeerState {
    public static final String _UNKNOWN = "Unknown";
    public static final CallPeerState UNKNOWN = new CallPeerState("Unknown", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.UNKNOWN_STATUS"));
    public static final String _INITIATING_CALL = "Initiating Call";
    public static final CallPeerState INITIATING_CALL = new CallPeerState("Initiating Call", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.INITIATING_CALL_STATUS"));
    public static final String _CONNECTING = "Connecting";
    public static final CallPeerState CONNECTING = new CallPeerState("Connecting", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.CONNECTING_STATUS"));
    public static final String _CONNECTING_WITH_EARLY_MEDIA = "Connecting*";
    public static final CallPeerState CONNECTING_WITH_EARLY_MEDIA = new CallPeerState("Connecting*", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.CONNECTING_EARLY_MEDIA_STATUS"));
    public static final CallPeerState CONNECTING_INCOMING_CALL = new CallPeerState("Connecting*", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.CONNECTING_STATUS"));
    public static final CallPeerState CONNECTING_INCOMING_CALL_WITH_MEDIA = new CallPeerState("Connecting*", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.CONNECTING_EARLY_MEDIA_STATUS"));
    public static final String _ALERTING_REMOTE_SIDE = "Alerting Remote User (Ringing)";
    public static final CallPeerState ALERTING_REMOTE_SIDE = new CallPeerState("Alerting Remote User (Ringing)", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.RINGING_STATUS"));
    public static final String _INCOMING_CALL = "Incoming Call";
    public static final CallPeerState INCOMING_CALL = new CallPeerState("Incoming Call", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.INCOMING_CALL_STATUS"));
    public static final String _CONNECTED = "Connected";
    public static final CallPeerState CONNECTED = new CallPeerState("Connected", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.CONNECTED_STATUS"));
    public static final String _DISCONNECTED = "Disconnected";
    public static final CallPeerState DISCONNECTED = new CallPeerState("Disconnected", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.DISCONNECTED_STATUS"));
    public static final String _REFERRED = "Referred";
    public static final CallPeerState REFERRED = new CallPeerState("Referred", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.REFERRED_STATUS"));
    public static final String _BUSY = "Busy";
    public static final CallPeerState BUSY = new CallPeerState("Busy", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.BUSY_STATUS"));
    public static final String _FAILED = "Failed";
    public static final CallPeerState FAILED = new CallPeerState("Failed", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.FAILED_STATUS"));
    public static final String _ON_HOLD_LOCALLY = "Locally On Hold";
    public static final CallPeerState ON_HOLD_LOCALLY = new CallPeerState("Locally On Hold", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.LOCALLY_ON_HOLD_STATUS"));
    public static final String _ON_HOLD_MUTUALLY = "Mutually On Hold";
    public static final CallPeerState ON_HOLD_MUTUALLY = new CallPeerState("Mutually On Hold", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.MUTUALLY_ON_HOLD_STATUS"));
    public static final String _ON_HOLD_REMOTELY = "Remotely On Hold";
    public static final CallPeerState ON_HOLD_REMOTELY = new CallPeerState("Remotely On Hold", ProtocolProviderActivator.getResourceService().getI18NString("service.gui.REMOTELY_ON_HOLD_STATUS"));
    private String callStateStr;
    private String callStateLocalizedStr;

    public static final boolean isOnHold(CallPeerState state) {
        return ON_HOLD_LOCALLY.equals(state) || ON_HOLD_MUTUALLY.equals(state) || ON_HOLD_REMOTELY.equals(state);
    }

    private CallPeerState(String callPeerState, String callStateLocalizedStr) {
        this.callStateStr = callPeerState;
        this.callStateLocalizedStr = callStateLocalizedStr;
    }

    public String getStateString() {
        return this.callStateStr;
    }

    public String getLocalizedStateString() {
        return this.callStateLocalizedStr;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getStateString();
    }
}

