/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.CheckList;
import org.ice4j.ice.Component;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.UPNPCandidate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IceMediaStream {
    private static final Logger logger = Logger.getLogger(IceMediaStream.class.getName());
    public static final String PROPERTY_PAIR_CONSENT_FRESHNESS_CHANGED = "PairConsentFreshnessChanged";
    public static final String PROPERTY_PAIR_NOMINATED = "PairNominated";
    public static final String PROPERTY_PAIR_STATE_CHANGED = "PairStateChanged";
    public static final String PROPERTY_PAIR_VALIDATED = "PairValidated";
    private final String name;
    private final Map<Integer, Component> components = new LinkedHashMap<Integer, Component>();
    private final TreeSet<CandidatePair> validList = new TreeSet();
    private int lastComponentID = 0;
    private final CheckList checkList;
    private final Agent parentAgent;
    private final List<PropertyChangeListener> streamListeners = new LinkedList<PropertyChangeListener>();
    private int maxCheckListSize = 100;
    private String remoteUfrag = null;
    private String remotePassword = null;

    protected IceMediaStream(Agent parentAgent, String name) {
        this.name = name;
        this.parentAgent = parentAgent;
        this.checkList = new CheckList(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Component createComponent(Transport transport) {
        Component component;
        Map<Integer, Component> map = this.components;
        synchronized (map) {
            component = new Component(++this.lastComponentID, transport, this);
            this.components.put(component.getComponentID(), component);
        }
        return component;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("media stream:").append(this.getName());
        buff.append(" (component count=").append(this.getComponentCount()).append(")");
        for (Component cmp : this.getComponents()) {
            buff.append("\n").append(cmp);
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(int id) {
        Map<Integer, Component> map = this.components;
        synchronized (map) {
            return this.components.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Component> getComponents() {
        Map<Integer, Component> map = this.components;
        synchronized (map) {
            return new ArrayList<Component>(this.components.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getComponentCount() {
        Map<Integer, Component> map = this.components;
        synchronized (map) {
            return this.components.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getComponentIDs() {
        Map<Integer, Component> map = this.components;
        synchronized (map) {
            return new ArrayList<Integer>(this.components.keySet());
        }
    }

    public int getStreamCount() {
        return this.getComponentCount();
    }

    public Agent getParentAgent() {
        return this.parentAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void free() {
        List<Component> components;
        Map<Integer, Component> map = this.components;
        synchronized (map) {
            components = this.getComponents();
            this.components.clear();
        }
        for (Component component : components) {
            component.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(Component component) {
        Map<Integer, Component> map = this.components;
        synchronized (map) {
            this.components.remove(component.getComponentID());
        }
        component.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCheckList() {
        CheckList checkList = this.checkList;
        synchronized (checkList) {
            this.checkList.clear();
            this.createCheckList(this.checkList);
            this.orderCheckList();
            this.pruneCheckList(this.checkList);
            logger.finest("Checklist initialized.");
        }
    }

    protected void createCheckList(List<CandidatePair> checkList) {
        for (Component cmp : this.getComponents()) {
            this.createCheckList(cmp, checkList);
        }
    }

    private void createCheckList(Component component, List<CandidatePair> checkList) {
        List<LocalCandidate> localCnds = component.getLocalCandidates();
        List<RemoteCandidate> remoteCnds = component.getRemoteCandidates();
        LocalCandidate upnpBase = null;
        for (LocalCandidate lc : localCnds) {
            if (!(lc instanceof UPNPCandidate)) continue;
            upnpBase = (LocalCandidate)lc.getBase();
        }
        for (LocalCandidate localCnd : localCnds) {
            if (localCnd == upnpBase) continue;
            for (RemoteCandidate remoteCnd : remoteCnds) {
                if (!localCnd.canReach(remoteCnd)) continue;
                CandidatePair pair = new CandidatePair(localCnd, remoteCnd);
                checkList.add(pair);
            }
        }
    }

    private void orderCheckList() {
        Collections.sort(this.checkList, CandidatePair.comparator);
    }

    protected void pruneCheckList(List<CandidatePair> checkList) {
        ArrayList<CandidatePair> tmpCheckList = new ArrayList<CandidatePair>(checkList.size());
        Iterator<CandidatePair> ckListIter = checkList.iterator();
        while (ckListIter.hasNext()) {
            CandidatePair pair = ckListIter.next();
            if (tmpCheckList.size() > this.maxCheckListSize) {
                ckListIter.remove();
                continue;
            }
            LocalCandidate localCnd = pair.getLocalCandidate();
            if (localCnd.getType() == CandidateType.SERVER_REFLEXIVE_CANDIDATE) {
                pair.setLocalCandidate((LocalCandidate)localCnd.getBase());
                if (tmpCheckList.contains(pair)) {
                    ckListIter.remove();
                    continue;
                }
            }
            tmpCheckList.add(pair);
        }
    }

    public CheckList getCheckList() {
        return this.checkList;
    }

    protected void setMaxCheckListSize(int nSize) {
        this.maxCheckListSize = nSize;
    }

    public LocalCandidate findLocalCandidate(TransportAddress localAddress) {
        for (Component cmp : this.components.values()) {
            LocalCandidate cnd = cmp.findLocalCandidate(localAddress);
            if (cnd == null) continue;
            return cnd;
        }
        return null;
    }

    public RemoteCandidate findRemoteCandidate(TransportAddress remoteAddress) {
        for (Component cmp : this.components.values()) {
            RemoteCandidate cnd = cmp.findRemoteCandidate(remoteAddress);
            if (cnd == null) continue;
            return cnd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CandidatePair findCandidatePair(TransportAddress localAddress, TransportAddress remoteAddress) {
        CheckList checkList = this.checkList;
        synchronized (checkList) {
            for (CandidatePair pair : this.checkList) {
                if (!pair.getLocalCandidate().getTransportAddress().equals(localAddress) || !pair.getRemoteCandidate().getTransportAddress().equals(remoteAddress)) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CandidatePair findCandidatePair(String localUFrag, String remoteUFrag) {
        CheckList checkList = this.checkList;
        synchronized (checkList) {
            for (CandidatePair pair : this.checkList) {
                LocalCandidate local = pair.getLocalCandidate();
                RemoteCandidate remote = pair.getRemoteCandidate();
                if (!local.getUfrag().equals(remoteUFrag) || !remote.getUfrag().equals(localUFrag)) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int countHostCandidates() {
        int num = 0;
        Map<Integer, Component> map = this.components;
        synchronized (map) {
            for (Component cmp : this.components.values()) {
                num += cmp.coundHostCandidates();
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToCheckList(CandidatePair candidatePair) {
        CheckList checkList = this.checkList;
        synchronized (checkList) {
            this.checkList.add(candidatePair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToValidList(CandidatePair pair) {
        TreeSet<CandidatePair> treeSet = this.validList;
        synchronized (treeSet) {
            if (!this.validList.contains(pair)) {
                this.validList.add(pair);
            }
        }
        pair.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validListContainsFoundation(String foundation) {
        TreeSet<CandidatePair> treeSet = this.validList;
        synchronized (treeSet) {
            for (CandidatePair pair : this.validList) {
                if (!pair.getFoundation().equals(foundation)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validListContainsNomineeForComponent(Component component) {
        TreeSet<CandidatePair> treeSet = this.validList;
        synchronized (treeSet) {
            for (CandidatePair pair : this.validList) {
                if (!pair.isNominated() || pair.getParentComponent() != component) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean validListContainsAllComponents() {
        for (Component cmp : this.getComponents()) {
            if (this.getValidPair(cmp) != null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allComponentsAreNominated() {
        List<Component> components = this.getComponents();
        TreeSet<CandidatePair> treeSet = this.validList;
        synchronized (treeSet) {
            for (CandidatePair pair : this.validList) {
                if (!pair.isNominated()) continue;
                components.remove(pair.getParentComponent());
            }
        }
        return components.isEmpty();
    }

    protected boolean allComponentsHaveSelected() {
        for (Component component : this.getComponents()) {
            if (component.getSelectedPair() != null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CandidatePair getValidPair(Component component) {
        TreeSet<CandidatePair> treeSet = this.validList;
        synchronized (treeSet) {
            for (CandidatePair pair : this.validList) {
                if (pair.getParentComponent() != component) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPairChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.streamListeners;
        synchronized (list) {
            if (!this.streamListeners.contains(l)) {
                this.streamListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePairStateChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.streamListeners;
        synchronized (list) {
            this.streamListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePairPropertyChange(CandidatePair source, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeListener[] ls;
        List<PropertyChangeListener> list = this.streamListeners;
        synchronized (list) {
            ls = this.streamListeners.toArray(new PropertyChangeListener[this.streamListeners.size()]);
        }
        PropertyChangeEvent ev = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
        for (PropertyChangeListener l : ls) {
            l.propertyChange(ev);
        }
    }

    public void setRemoteUfrag(String remoteUfrag) {
        this.remoteUfrag = remoteUfrag;
    }

    public String getRemoteUfrag() {
        return this.remoteUfrag;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }
}

