/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;

public class LangFunction
implements Function {
    private static final String LANG_LOCALNAME = "lang";
    private static final String XMLNS_URI = "http://www.w3.org/XML/1998/namespace";

    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 1) {
            if (args.get(0) instanceof String) {
                try {
                    return LangFunction.evaluate(context.getNodeSet(), (String)args.get(0), context.getNavigator());
                }
                catch (UnsupportedAxisException e) {
                    throw new FunctionCallException("Can't evaluate lang()", e);
                }
            }
            throw new FunctionCallException("lang() requires a string argument.");
        }
        throw new FunctionCallException("lang() requires exactly one argument.");
    }

    public static Boolean evaluate(List contextNodes, String lang, Navigator nav) throws UnsupportedAxisException {
        Iterator nodes = contextNodes.iterator();
        while (nodes.hasNext()) {
            if (LangFunction.evaluate(nodes.next(), lang, nav)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static boolean evaluate(Object node, String lang, Navigator nav) throws UnsupportedAxisException {
        Iterator elements = nav.getAncestorOrSelfAxisIterator(node);
        while (elements.hasNext()) {
            Iterator attrs = nav.getAttributeAxisIterator(elements.next());
            if (attrs == null) continue;
            while (attrs.hasNext()) {
                Object attr = attrs.next();
                if (!LANG_LOCALNAME.equals(nav.getAttributeName(attr)) || !XMLNS_URI.equals(nav.getAttributeNamespaceUri(attr))) continue;
                return LangFunction.isSublang(nav.getAttributeStringValue(attr), lang);
            }
        }
        return false;
    }

    private static boolean isSublang(String sublang, String lang) {
        if (sublang.equalsIgnoreCase(lang)) {
            return true;
        }
        int ll = lang.length();
        return sublang.length() > ll && sublang.charAt(ll) == '-' && sublang.substring(0, ll).equalsIgnoreCase(lang);
    }
}

