/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.IdentityHashMap;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.ConnectionQueueMgr;
import net.kano.joscar.ratelim.QueueRunner;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacQueueManager;
import net.kano.joscar.snac.SnacRequest;

public class RateLimitingQueueMgr
implements SnacQueueManager {
    private final Map connMgrs = new IdentityHashMap();
    private final QueueRunner runner = new QueueRunner();

    public RateLimitingQueueMgr() {
        new Thread(this.runner).start();
    }

    final QueueRunner getRunner() {
        return this.runner;
    }

    void sendSnac(ClientSnacProcessor clientSnacProcessor, SnacRequest snacRequest) {
        clientSnacProcessor.sendSnacImmediately(snacRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConnectionQueueMgr[] getQueueMgrs() {
        Map map = this.connMgrs;
        synchronized (map) {
            return this.connMgrs.values().toArray(new ConnectionQueueMgr[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConnectionQueueMgr getQueueMgr(ClientSnacProcessor clientSnacProcessor) {
        DefensiveTools.checkNull(clientSnacProcessor, "processor");
        Map map = this.connMgrs;
        synchronized (map) {
            return (ConnectionQueueMgr)this.connMgrs.get(clientSnacProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attached(ClientSnacProcessor clientSnacProcessor) {
        Map map = this.connMgrs;
        synchronized (map) {
            this.connMgrs.put(clientSnacProcessor, new ConnectionQueueMgr(this, clientSnacProcessor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detached(ClientSnacProcessor clientSnacProcessor) {
        ConnectionQueueMgr connectionQueueMgr;
        Map map = this.connMgrs;
        synchronized (map) {
            connectionQueueMgr = (ConnectionQueueMgr)this.connMgrs.remove(clientSnacProcessor);
        }
        connectionQueueMgr.detach();
    }

    public void queueSnac(ClientSnacProcessor clientSnacProcessor, SnacRequest snacRequest) {
        DefensiveTools.checkNull(snacRequest, "request");
        this.getQueueMgr(clientSnacProcessor).queueSnac(snacRequest);
    }

    public void clearQueue(ClientSnacProcessor clientSnacProcessor) {
        this.getQueueMgr(clientSnacProcessor).clearQueue();
    }

    public void pause(ClientSnacProcessor clientSnacProcessor) {
        this.getQueueMgr(clientSnacProcessor).pause();
    }

    public void unpause(ClientSnacProcessor clientSnacProcessor) {
        this.getQueueMgr(clientSnacProcessor).unpause();
    }
}

