/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.base.DefaultNodeInitializer;
import com.hazelcast.impl.base.NodeInitializer;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.AbstractSerializer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;

public final class NodeInitializerFactory {
    private static final ILogger logger = Logger.getLogger(NodeInitializerFactory.class.getName());
    private static final String FACTORY_ID = "com.hazelcast.NodeInitializer";

    public static NodeInitializer create() {
        NodeInitializer initializer = null;
        String initializerClassname = ServiceLoader.load(FACTORY_ID);
        if (initializerClassname != null) {
            try {
                Class<?> klass = AbstractSerializer.loadClass(initializerClassname);
                initializer = (NodeInitializer)AbstractSerializer.newInstance(klass);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Initializer instance of class[" + initializerClassname + "] " + "could not be instantiated! => " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        return initializer != null ? initializer : NodeInitializerFactory.createDefault();
    }

    public static NodeInitializer createDefault() {
        return new DefaultNodeInitializer();
    }

    private static class ServiceLoader {
        private ServiceLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static String load(String factoryId) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String resourceName = "META-INF/services/" + factoryId;
            try {
                Enumeration<URL> configs = cl != null ? cl.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
                block5: while (configs.hasMoreElements()) {
                    URL url = configs.nextElement();
                    InputStream in = url.openStream();
                    try {
                        String line;
                        String name;
                        BufferedReader r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                        do {
                            if ((line = r.readLine()) == null) continue block5;
                            int comment = line.indexOf(35);
                            if (comment < 0) continue;
                            line = line.substring(0, comment);
                        } while ((name = line.trim()).length() == 0);
                        String string = name;
                        return string;
                    }
                    finally {
                        in.close();
                    }
                }
                return null;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            return null;
        }
    }
}

