/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.proxy;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.logicalcobwebs.proxool.ProxoolException;

public class MethodMapper {
    private Class concreteClass;
    private Map cachedConcreteMethods = new HashMap();

    public MethodMapper(Class concreteClass) {
        this.concreteClass = concreteClass;
    }

    protected Method getConcreteMethod(Method injectableMethod) throws ProxoolException {
        Method concreteMethod = (Method)this.cachedConcreteMethods.get(injectableMethod);
        if (concreteMethod == null) {
            Method[] candidateMethods = this.concreteClass.getMethods();
            for (int i = 0; i < candidateMethods.length; ++i) {
                Method candidateMethod = candidateMethods[i];
                if (!candidateMethod.getName().equals(injectableMethod.getName()) || candidateMethod.getParameterTypes().length != injectableMethod.getParameterTypes().length || !candidateMethod.getReturnType().equals(injectableMethod.getReturnType())) continue;
                boolean matches = true;
                Class<?>[] candidateTypes = candidateMethod.getParameterTypes();
                Class<?>[] injectableTypes = injectableMethod.getParameterTypes();
                for (int j = 0; j < candidateTypes.length; ++j) {
                    if (candidateTypes[j].equals(injectableTypes[j])) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                concreteMethod = candidateMethod;
                break;
            }
            if (concreteMethod == null) {
                throw new ProxoolException("Couldn't match injectable method " + injectableMethod + " with any of those " + "found in " + this.concreteClass.getName());
            }
            this.cachedConcreteMethods.put(injectableMethod, concreteMethod);
        }
        return concreteMethod;
    }

    public void overrideConcreteMethod(Method injectableMethod, Method overridenMethod) {
        this.cachedConcreteMethods.put(injectableMethod, overridenMethod);
    }
}

