/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.parser.rules;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.html.BlockExtractingRule;
import com.opensymphony.module.sitemesh.html.Tag;

public class MSOfficeDocumentPropertiesRule
extends BlockExtractingRule {
    private final HTMLPage page;
    private boolean inDocumentProperties;

    public MSOfficeDocumentPropertiesRule(HTMLPage page) {
        super(true);
        this.page = page;
    }

    public boolean shouldProcess(String name) {
        return this.inDocumentProperties && name.startsWith("o:") || name.equals("o:DocumentProperties");
    }

    public void process(Tag tag) {
        if (tag.getName().equals("o:DocumentProperties")) {
            this.inDocumentProperties = tag.getType() == 1;
            tag.writeTo(this.context.currentBuffer());
        } else {
            super.process(tag);
        }
    }

    protected void start(Tag tag) {
    }

    protected void end(Tag tag) {
        String name = tag.getName().substring(2);
        this.page.addProperty("office.DocumentProperties." + name, this.context.currentBuffer().toString());
        this.context.mergeBuffer();
    }
}

