/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.search;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import org.jetbrains.annotations.Nullable;

public class InterestInfo
implements LiveWritable {
    public static final int TYPE_PARENT = 1;
    public static final int TYPE_CHILD = 2;
    private final int type;
    private final int parent;
    private final String name;
    private final int totalSize;

    @Nullable
    protected static InterestInfo readInterestInfo(ByteBlock block) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        if (block.getLength() < 4) {
            return null;
        }
        short type = BinaryTools.getUByte((ByteBlock)block, (int)0);
        short parent = BinaryTools.getUByte((ByteBlock)block, (int)1);
        int namelen = BinaryTools.getUShort((ByteBlock)block, (int)2);
        if (block.getLength() < namelen + 4) {
            return null;
        }
        ByteBlock nameBlock = block.subBlock(4, namelen);
        String name = BinaryTools.getAsciiString((ByteBlock)nameBlock);
        int size = 4 + namelen;
        return new InterestInfo(type, parent, name, size);
    }

    protected InterestInfo(int type, int parent, String name, int totalSize) {
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        DefensiveTools.checkRange((int)parent, (String)"parent", (int)0);
        DefensiveTools.checkNull((Object)name, (String)"name");
        DefensiveTools.checkRange((int)totalSize, (String)"totalSize", (int)-1);
        this.type = type;
        this.parent = parent;
        this.name = name;
        this.totalSize = totalSize;
    }

    public InterestInfo(int type, int parent, String name) {
        this(type, parent, name, -1);
    }

    public final int getType() {
        return this.type;
    }

    public final int getParentId() {
        return this.parent;
    }

    public final String getName() {
        return this.name;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUByte((OutputStream)out, (int)this.type);
        BinaryTools.writeUByte((OutputStream)out, (int)this.parent);
        byte[] namebytes = BinaryTools.getAsciiBytes((String)this.name);
        BinaryTools.writeUShort((OutputStream)out, (int)namebytes.length);
        out.write(namebytes);
    }

    public String toString() {
        return "InterestInfo: type=" + this.type + ", parent=" + this.parent + ": " + this.name;
    }
}

