/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LoadProperties
extends Task {
    private File srcFile;
    private String resource;
    private Path classpath;
    private final Vector filterChains;
    private String encoding;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$LoadProperties;

    public final void setSrcFile(File file) {
        this.srcFile = file;
    }

    public final void setResource(String string) {
        this.resource = string;
    }

    public final void setEncoding(String string) {
        this.encoding = string;
    }

    public final void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public final Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public final void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public final Path getClasspath() {
        return this.classpath;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute() throws BuildException {
        InputStream inputStream;
        Object object;
        if (this.srcFile == null && this.resource == null) {
            throw new BuildException("One of \"srcfile\" or \"resource\" is required.");
        }
        BufferedInputStream bufferedInputStream = null;
        if (this.srcFile != null) {
            if (!this.srcFile.exists()) {
                throw new BuildException("Source file does not exist.");
            }
            if (!this.srcFile.isFile()) {
                throw new BuildException("Source file is not a file.");
            }
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(this.srcFile));
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
        } else {
            ClassLoader classLoader;
            if (this.classpath != null) {
                classLoader = this.getProject().createClassLoader(this.classpath);
            } else {
                Class clazz = class$org$apache$tools$ant$taskdefs$LoadProperties;
                if (clazz == null) {
                    clazz = class$org$apache$tools$ant$taskdefs$LoadProperties = LoadProperties.class("[Lorg.apache.tools.ant.taskdefs.LoadProperties;", false);
                }
                classLoader = clazz.getClassLoader();
            }
            object = classLoader;
            InputStream inputStream2 = inputStream = object == null ? ClassLoader.getSystemResourceAsStream(this.resource) : ((ClassLoader)object).getResourceAsStream(this.resource);
            if (inputStream == null) {
                this.log("Unable to find resource " + this.resource, 1);
                return;
            }
            bufferedInputStream = new BufferedInputStream(inputStream);
        }
        object = null;
        inputStream = null;
        try {
            try {
                object = this.encoding == null ? new InputStreamReader(bufferedInputStream) : new InputStreamReader((InputStream)bufferedInputStream, this.encoding);
                ChainReaderHelper chainReaderHelper = new ChainReaderHelper();
                chainReaderHelper.setPrimaryReader((Reader)object);
                chainReaderHelper.setFilterChains(this.filterChains);
                chainReaderHelper.setProject(this.getProject());
                object = chainReaderHelper.getAssembledReader();
                String string = chainReaderHelper.readFully((Reader)object);
                if (string != null) {
                    if (!string.endsWith("\n")) {
                        string = string + '\n';
                    }
                    inputStream = this.encoding == null ? new ByteArrayInputStream(string.getBytes()) : new ByteArrayInputStream(string.getBytes(this.encoding));
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    Property property = (Property)this.getProject().createTask("property");
                    property.setTaskName(this.getTaskName());
                    property.addProperties(properties);
                }
            }
            catch (IOException iOException) {
                String string = "Unable to load file: " + iOException.toString();
                throw new BuildException(string, iOException, this.getLocation());
            }
            catch (BuildException buildException) {
                throw buildException;
            }
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputStream == null) throw throwable;
                ((ByteArrayInputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_14 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (bufferedInputStream != null) {
            bufferedInputStream.close();
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (inputStream == null) return;
        ((ByteArrayInputStream)inputStream).close();
    }

    public final void addFilterChain(FilterChain filterChain) {
        this.filterChains.addElement(filterChain);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.srcFile = null;
        this.resource = null;
        this.classpath = null;
        this.filterChains = new Vector();
        this.encoding = null;
    }

    public LoadProperties() {
        this.this();
    }
}

