/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jrobin.core.RrdException;

class RrdCmdScanner {
    private LinkedList<String> words = new LinkedList();
    private StringBuffer buff;

    RrdCmdScanner(String string) throws RrdException {
        String string2 = string.trim();
        char c = '\u0000';
        for (int i = 0; i < string2.length(); ++i) {
            char c2;
            char c3 = string2.charAt(i);
            if ((c3 == '\"' || c3 == '\'') && c == '\u0000') {
                this.initWord();
                c = c3;
                continue;
            }
            if (c3 == c) {
                c = '\u0000';
                continue;
            }
            if (this.isSeparator(c3) && c == '\u0000') {
                this.finishWord();
                continue;
            }
            if (c3 == '\\' && c == '\"' && i + 1 < string2.length() && ((c2 = string2.charAt(i + 1)) == '\\' || c2 == '\"')) {
                this.appendWord(c2);
                ++i;
                continue;
            }
            this.appendWord(c3);
        }
        if (c != '\u0000') {
            throw new RrdException("End of command reached but " + c + " expected");
        }
        this.finishWord();
    }

    String getCmdType() {
        if (this.words.size() > 0) {
            return this.words.get(0);
        }
        return null;
    }

    private void appendWord(char c) {
        if (this.buff == null) {
            this.buff = new StringBuffer("");
        }
        this.buff.append(c);
    }

    private void finishWord() {
        if (this.buff != null) {
            this.words.add(this.buff.toString());
            this.buff = null;
        }
    }

    private void initWord() {
        if (this.buff == null) {
            this.buff = new StringBuffer("");
        }
    }

    void dump() {
        for (String string : this.words) {
            System.out.println(string);
        }
    }

    String getOptionValue(String string, String string2, String string3) throws RrdException {
        String string4 = null;
        if (string != null) {
            string4 = this.getOptionValue("-" + string);
        }
        if (string4 == null && string2 != null) {
            string4 = this.getOptionValue("--" + string2);
        }
        if (string4 == null) {
            string4 = string3;
        }
        return string4;
    }

    String getOptionValue(String string, String string2) throws RrdException {
        return this.getOptionValue(string, string2, null);
    }

    private String getOptionValue(String string) throws RrdException {
        ListIterator listIterator = this.words.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (string2.equals(string)) {
                if (listIterator.hasNext()) {
                    listIterator.remove();
                    String string3 = (String)listIterator.next();
                    listIterator.remove();
                    return string3;
                }
                throw new RrdException("Value for option " + string + " expected but not found");
            }
            if (!string2.startsWith(string)) continue;
            int n = string.length();
            if (string2.charAt(n) == '=') {
                ++n;
            }
            listIterator.remove();
            return string2.substring(n);
        }
        return null;
    }

    boolean getBooleanOption(String string, String string2) {
        ListIterator listIterator = this.words.listIterator();
        while (listIterator.hasNext()) {
            String string3 = (String)listIterator.next();
            if ((string == null || !string3.equals("-" + string)) && (string2 == null || !string3.equals("--" + string2))) continue;
            listIterator.remove();
            return true;
        }
        return false;
    }

    String[] getMultipleOptions(String string, String string2) throws RrdException {
        String string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string3 = this.getOptionValue(string, string2, null)) != null) {
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    String[] getRemainingWords() {
        return this.words.toArray(new String[this.words.size()]);
    }

    boolean isSeparator(char c) {
        return Character.isWhitespace(c);
    }
}

