/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.BitSet;
import net.sf.jml.util.Charset;
import net.sf.jml.util.NumberUtils;
import sun.security.action.GetPropertyAction;

public class StringUtils {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;
    private static final int fillchar = 61;
    private static final String cvt = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static String urlEncode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "UTF-8";
        boolean bl = false;
        boolean bl2 = false;
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (dontNeedEncoding.get(c)) {
                stringBuffer.append(c);
                bl2 = true;
                continue;
            }
            try {
                char c2;
                if (bl2) {
                    outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2);
                    bl2 = false;
                }
                outputStreamWriter.write(c);
                if (c >= '\ud800' && c <= '\udbff' && i + 1 < string.length() && (c2 = string.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                    outputStreamWriter.write(c2);
                    ++i;
                }
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                stringBuffer.append('%');
                char c3 = Character.forDigit(byArray[j] >> 4 & 0xF, 16);
                if (Character.isLetter(c3)) {
                    c3 = (char)(c3 - 32);
                }
                stringBuffer.append(c3);
                c3 = Character.forDigit(byArray[j] & 0xF, 16);
                if (Character.isLetter(c3)) {
                    c3 = (char)(c3 - 32);
                }
                stringBuffer.append(c3);
            }
            byteArrayOutputStream.reset();
            bl = true;
        }
        return bl ? stringBuffer.toString() : string;
    }

    public static String urlDecode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String ltrim(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = string.charAt(i);
            if (c == ' ') continue;
            stringBuffer.append(cArray, i, cArray.length - i);
            break;
        }
        return stringBuffer.toString();
    }

    public static String rtrim(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = cArray.length; i > 0; --i) {
            char c = string.charAt(i - 1);
            if (c == ' ') continue;
            stringBuffer.append(cArray, 0, i);
            break;
        }
        return stringBuffer.toString();
    }

    public static String xmlEscaping(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&apos;");
        return string;
    }

    public static String debug(ByteBuffer byteBuffer) {
        int n = (int)Math.ceil((double)byteBuffer.remaining() / 16.0);
        StringBuffer stringBuffer = new StringBuffer(n * 80);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = new byte[Math.min(16, byteBuffer.remaining())];
            byteBuffer.get(byArray);
            stringBuffer.append(NumberUtils.toHexValue(n2));
            stringBuffer.append("h: ");
            for (int j = 0; j < 16; ++j) {
                if (j < byArray.length) {
                    stringBuffer.append(NumberUtils.toHexValue(byArray[j]).toUpperCase());
                } else {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(" ");
            }
            stringBuffer.append("; ");
            String string = Charset.decode(byArray);
            char[] cArray = string.toCharArray();
            for (int j = 0; j < cArray.length; ++j) {
                if (Character.isISOControl(cArray[j])) {
                    stringBuffer.append('.');
                    continue;
                }
                stringBuffer.append(cArray[j]);
            }
            stringBuffer.append("\r\n");
            n2 += 16;
        }
        return stringBuffer.toString();
    }

    public static String encodeBase64(String string) {
        return StringUtils.encodeBase64(string.getBytes());
    }

    public static String encodeBase64(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer((n / 3 + 1) * 4);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] >> 2 & 0x3F;
            stringBuffer.append(cvt.charAt(n2));
            n2 = byArray[i] << 4 & 0x3F;
            if (++i < n) {
                n2 |= byArray[i] >> 4 & 0xF;
            }
            stringBuffer.append(cvt.charAt(n2));
            if (i < n) {
                n2 = byArray[i] << 2 & 0x3F;
                if (++i < n) {
                    n2 |= byArray[i] >> 6 & 3;
                }
                stringBuffer.append(cvt.charAt(n2));
            } else {
                ++i;
                stringBuffer.append('=');
            }
            if (i < n) {
                n2 = byArray[i] & 0x3F;
                stringBuffer.append(cvt.charAt(n2));
                continue;
            }
            stringBuffer.append('=');
        }
        return stringBuffer.toString();
    }

    public static String decodeBase64(String string) {
        return StringUtils.decodeBase64(string.getBytes());
    }

    public static String decodeBase64(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 3 / 4);
        for (int i = 0; i < n; ++i) {
            int n2 = cvt.indexOf(byArray[i]);
            int n3 = cvt.indexOf(byArray[++i]);
            n2 = n2 << 2 | n3 >> 4 & 3;
            stringBuffer.append((char)n2);
            if (++i < n) {
                n2 = byArray[i];
                if (61 == n2) break;
                n2 = cvt.indexOf((char)n2);
                n3 = n3 << 4 & 0xF0 | n2 >> 2 & 0xF;
                stringBuffer.append((char)n3);
            }
            if (++i >= n) continue;
            n3 = byArray[i];
            if (61 == n3) break;
            n3 = cvt.indexOf((char)n3);
            n2 = n2 << 6 & 0xC0 | n3;
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    static {
        int n;
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontNeedEncoding.set(n);
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dfltEncName = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
    }
}

