/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class ProcessorModel {
    private MediaLocator inputLocator;
    private Format[] formats;
    private ContentDescriptor outputContentDescriptor;
    private DataSource inputDataSource;

    public ProcessorModel() {
    }

    public ProcessorModel(DataSource dataSource, Format[] formatArray, ContentDescriptor contentDescriptor) {
        this.inputDataSource = dataSource;
        this.formats = formatArray;
        this.outputContentDescriptor = contentDescriptor;
    }

    public ProcessorModel(Format[] formatArray, ContentDescriptor contentDescriptor) {
        this.formats = formatArray;
        this.outputContentDescriptor = contentDescriptor;
    }

    public ProcessorModel(MediaLocator mediaLocator, Format[] formatArray, ContentDescriptor contentDescriptor) {
        this.inputLocator = mediaLocator;
        this.formats = formatArray;
        this.outputContentDescriptor = contentDescriptor;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.outputContentDescriptor;
    }

    public DataSource getInputDataSource() {
        return this.inputDataSource;
    }

    public MediaLocator getInputLocator() {
        return this.inputLocator;
    }

    public Format getOutputTrackFormat(int n) {
        if (this.formats == null) {
            return null;
        }
        if (n < 0 || n >= this.formats.length) {
            return null;
        }
        return this.formats[n];
    }

    public int getTrackCount(int n) {
        if (this.formats == null) {
            return -1;
        }
        return this.formats.length;
    }

    public boolean isFormatAcceptable(int n, Format format) {
        if (this.formats == null) {
            return true;
        }
        if (n < 0 || n >= this.formats.length) {
            return true;
        }
        return format.matches(this.formats[n]);
    }
}

